/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class CirSim
extends Frame
implements ComponentListener,
ActionListener,
AdjustmentListener,
MouseMotionListener,
MouseListener,
ItemListener,
KeyListener {
    Thread engine = null;
    Dimension winSize;
    Image dbimage;
    Random random;
    public static final int sourceRadius = 7;
    public static final double freqMult = 25.1327412;
    static Container main;
    Label titleLabel;
    Button resetButton;
    Button dumpMatrixButton;
    MenuItem exportItem;
    MenuItem importItem;
    MenuItem exitItem;
    MenuItem undoItem;
    MenuItem redoItem;
    MenuItem cutItem;
    MenuItem copyItem;
    MenuItem pasteItem;
    MenuItem selectAllItem;
    MenuItem optionsItem;
    Menu optionsMenu;
    Checkbox stoppedCheck;
    CheckboxMenuItem dotsCheckItem;
    CheckboxMenuItem voltsCheckItem;
    CheckboxMenuItem powerCheckItem;
    CheckboxMenuItem smallGridCheckItem;
    CheckboxMenuItem showValuesCheckItem;
    CheckboxMenuItem conductanceCheckItem;
    CheckboxMenuItem euroResistorCheckItem;
    CheckboxMenuItem printableCheckItem;
    CheckboxMenuItem conventionCheckItem;
    Scrollbar speedBar;
    Scrollbar currentBar;
    Label powerLabel;
    Scrollbar powerBar;
    PopupMenu elmMenu;
    MenuItem elmEditMenuItem;
    MenuItem elmCutMenuItem;
    MenuItem elmCopyMenuItem;
    MenuItem elmDeleteMenuItem;
    MenuItem elmScopeMenuItem;
    PopupMenu scopeMenu;
    PopupMenu transScopeMenu;
    PopupMenu mainMenu;
    CheckboxMenuItem scopeVMenuItem;
    CheckboxMenuItem scopeIMenuItem;
    CheckboxMenuItem scopeMaxMenuItem;
    CheckboxMenuItem scopeMinMenuItem;
    CheckboxMenuItem scopeFreqMenuItem;
    CheckboxMenuItem scopePowerMenuItem;
    CheckboxMenuItem scopeIbMenuItem;
    CheckboxMenuItem scopeIcMenuItem;
    CheckboxMenuItem scopeIeMenuItem;
    CheckboxMenuItem scopeVbeMenuItem;
    CheckboxMenuItem scopeVbcMenuItem;
    CheckboxMenuItem scopeVceMenuItem;
    CheckboxMenuItem scopeVIMenuItem;
    CheckboxMenuItem scopeXYMenuItem;
    CheckboxMenuItem scopeResistMenuItem;
    CheckboxMenuItem scopeVceIcMenuItem;
    MenuItem scopeSelectYMenuItem;
    Class addingClass;
    int mouseMode = 6;
    int tempMouseMode = 6;
    String mouseModeStr = "Select";
    static final double pi = Math.PI;
    static final int MODE_ADD_ELM = 0;
    static final int MODE_DRAG_ALL = 1;
    static final int MODE_DRAG_ROW = 2;
    static final int MODE_DRAG_COLUMN = 3;
    static final int MODE_DRAG_SELECTED = 4;
    static final int MODE_DRAG_POST = 5;
    static final int MODE_SELECT = 6;
    static final int infoWidth = 120;
    int dragX;
    int dragY;
    int initDragX;
    int initDragY;
    int selectedSource;
    Rectangle selectedArea;
    int gridSize;
    int gridMask;
    int gridRound;
    boolean dragging;
    boolean analyzeFlag;
    boolean dumpMatrix;
    boolean useBufferedImage;
    boolean isMac;
    String ctrlMetaKey;
    double t;
    int pause = 10;
    int scopeSelected = -1;
    int menuScope = -1;
    int hintType = -1;
    int hintItem1;
    int hintItem2;
    String stopMessage;
    double timeStep;
    static final int HINT_LC = 1;
    static final int HINT_RC = 2;
    static final int HINT_3DB_C = 3;
    static final int HINT_TWINT = 4;
    static final int HINT_3DB_L = 5;
    Vector elmList;
    Vector setupList;
    CircuitElm dragElm;
    CircuitElm menuElm;
    CircuitElm mouseElm;
    CircuitElm stopElm;
    int mousePost = -1;
    CircuitElm plotXElm;
    CircuitElm plotYElm;
    int draggingPost;
    SwitchElm heldSwitchElm;
    double[][] circuitMatrix;
    double[] circuitRightSide;
    double[] origRightSide;
    double[][] origMatrix;
    RowInfo[] circuitRowInfo;
    int[] circuitPermute;
    boolean circuitNonLinear;
    int voltageSourceCount;
    int circuitMatrixSize;
    int circuitMatrixFullSize;
    boolean circuitNeedsMap;
    public boolean useFrame;
    int scopeCount;
    Scope[] scopes;
    int[] scopeColCount;
    static EditDialog editDialog;
    static ImportDialog impDialog;
    Class[] dumpTypes;
    static String muString;
    static String ohmString;
    String clipboard;
    Rectangle circuitArea;
    int circuitBottom;
    Vector undoStack;
    Vector redoStack;
    CircuitCanvas cv;
    Circuit applet;
    String startCircuit = null;
    String startLabel = null;
    boolean shown = false;
    static final int resct = 6;
    long lastTime = 0L;
    long lastFrameTime;
    long lastIterTime;
    long secTime = 0L;
    int frames = 0;
    int steps = 0;
    int framerate = 0;
    int steprate = 0;
    Vector nodeList;
    CircuitElm[] voltageSources;
    boolean converged;
    int subIterations;

    public String getAppletInfo() {
        return "Circuit by Paul Falstad";
    }

    int getrand(int n) {
        int n2 = this.random.nextInt();
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2 % n;
    }

    CirSim(Circuit circuit) {
        super("Circuit Simulator v1.5h");
        this.applet = circuit;
        this.useFrame = false;
    }

    public void init() {
        String string;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = true;
        CircuitElm.initClass(this);
        try {
            String string4 = this.applet.getParameter("PAUSE");
            if (string4 != null) {
                this.pause = Integer.parseInt(string4);
            }
            this.startCircuit = this.applet.getParameter("startCircuit");
            this.startLabel = this.applet.getParameter("startLabel");
            string2 = this.applet.getParameter("euroResistors");
            string3 = this.applet.getParameter("useFrame");
            string = this.applet.getParameter("whiteBackground");
            if (string != null && string.equalsIgnoreCase("true")) {
                bl = true;
            }
            if ((string = this.applet.getParameter("conventionalCurrent")) != null && string.equalsIgnoreCase("true")) {
                bl2 = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl3 = string2 != null && string2.equalsIgnoreCase("true");
        this.useFrame = string3 == null || !string3.equalsIgnoreCase("false");
        main = this.useFrame ? this : this.applet;
        string = System.getProperty("os.name");
        this.isMac = string.indexOf("Mac ") == 0;
        this.ctrlMetaKey = this.isMac ? "\u2318" : "Ctrl";
        String string5 = System.getProperty("java.class.version");
        double d = new Double(string5);
        if (d >= 48.0) {
            muString = "\u03bc";
            ohmString = "\u03a9";
            this.useBufferedImage = true;
        }
        this.dumpTypes = new Class[300];
        this.dumpTypes[111] = Scope.class;
        this.dumpTypes[104] = Scope.class;
        this.dumpTypes[36] = Scope.class;
        this.dumpTypes[37] = Scope.class;
        this.dumpTypes[63] = Scope.class;
        this.dumpTypes[66] = Scope.class;
        main.setLayout(new CircuitLayout());
        this.cv = new CircuitCanvas(this);
        this.cv.addComponentListener(this);
        this.cv.addMouseMotionListener(this);
        this.cv.addMouseListener(this);
        this.cv.addKeyListener(this);
        main.add(this.cv);
        this.mainMenu = new PopupMenu();
        MenuBar menuBar = null;
        if (this.useFrame) {
            menuBar = new MenuBar();
        }
        Menu menu = new Menu("File");
        if (this.useFrame) {
            menuBar.add(menu);
        } else {
            this.mainMenu.add(menu);
        }
        this.importItem = this.getMenuItem("Import");
        menu.add(this.importItem);
        this.exportItem = this.getMenuItem("Export");
        menu.add(this.exportItem);
        menu.addSeparator();
        this.exitItem = this.getMenuItem("Exit");
        menu.add(this.exitItem);
        menu = new Menu("Edit");
        this.undoItem = this.getMenuItem("Undo");
        menu.add(this.undoItem);
        this.undoItem.setShortcut(new MenuShortcut(90));
        this.redoItem = this.getMenuItem("Redo");
        menu.add(this.redoItem);
        this.redoItem.setShortcut(new MenuShortcut(90, true));
        menu.addSeparator();
        this.cutItem = this.getMenuItem("Cut");
        menu.add(this.cutItem);
        this.cutItem.setShortcut(new MenuShortcut(88));
        this.copyItem = this.getMenuItem("Copy");
        menu.add(this.copyItem);
        this.copyItem.setShortcut(new MenuShortcut(67));
        this.pasteItem = this.getMenuItem("Paste");
        menu.add(this.pasteItem);
        this.pasteItem.setShortcut(new MenuShortcut(86));
        this.pasteItem.setEnabled(false);
        this.selectAllItem = this.getMenuItem("Select All");
        menu.add(this.selectAllItem);
        this.selectAllItem.setShortcut(new MenuShortcut(65));
        if (this.useFrame) {
            menuBar.add(menu);
        } else {
            this.mainMenu.add(menu);
        }
        menu = new Menu("Scope");
        if (this.useFrame) {
            menuBar.add(menu);
        } else {
            this.mainMenu.add(menu);
        }
        menu.add(this.getMenuItem("Stack All", "stackAll"));
        menu.add(this.getMenuItem("Unstack All", "unstackAll"));
        this.optionsMenu = menu = new Menu("Options");
        if (this.useFrame) {
            menuBar.add(menu);
        } else {
            this.mainMenu.add(menu);
        }
        this.dotsCheckItem = this.getCheckItem("Show Current");
        menu.add(this.dotsCheckItem);
        this.dotsCheckItem.setState(true);
        this.voltsCheckItem = this.getCheckItem("Show Voltage");
        menu.add(this.voltsCheckItem);
        this.voltsCheckItem.setState(true);
        this.powerCheckItem = this.getCheckItem("Show Power");
        menu.add(this.powerCheckItem);
        this.showValuesCheckItem = this.getCheckItem("Show Values");
        menu.add(this.showValuesCheckItem);
        this.showValuesCheckItem.setState(true);
        this.smallGridCheckItem = this.getCheckItem("Small Grid");
        menu.add(this.smallGridCheckItem);
        this.euroResistorCheckItem = this.getCheckItem("European Resistors");
        menu.add(this.euroResistorCheckItem);
        this.euroResistorCheckItem.setState(bl3);
        this.printableCheckItem = this.getCheckItem("White Background");
        menu.add(this.printableCheckItem);
        this.printableCheckItem.setState(bl);
        this.conventionCheckItem = this.getCheckItem("Conventional Current Motion");
        menu.add(this.conventionCheckItem);
        this.conventionCheckItem.setState(bl2);
        this.optionsItem = this.getMenuItem("Other Options...");
        menu.add(this.optionsItem);
        Menu menu2 = new Menu("Circuits");
        if (this.useFrame) {
            menuBar.add(menu2);
        } else {
            this.mainMenu.add(menu2);
        }
        this.mainMenu.add(this.getClassCheckItem("Add Wire", "WireElm"));
        this.mainMenu.add(this.getClassCheckItem("Add Resistor", "ResistorElm"));
        Menu menu3 = new Menu("Passive Components");
        this.mainMenu.add(menu3);
        menu3.add(this.getClassCheckItem("Add Capacitor", "CapacitorElm"));
        menu3.add(this.getClassCheckItem("Add Inductor", "InductorElm"));
        menu3.add(this.getClassCheckItem("Add Switch", "SwitchElm"));
        menu3.add(this.getClassCheckItem("Add Push Switch", "PushSwitchElm"));
        menu3.add(this.getClassCheckItem("Add DPST Switch", "Switch2Elm"));
        menu3.add(this.getClassCheckItem("Add Potentiometer", "PotElm"));
        menu3.add(this.getClassCheckItem("Add Transformer", "TransformerElm"));
        menu3.add(this.getClassCheckItem("Add Tapped Transformer", "TappedTransformerElm"));
        menu3.add(this.getClassCheckItem("Add Transmission Line", "TransLineElm"));
        menu3.add(this.getClassCheckItem("Add Relay", "RelayElm"));
        menu3.add(this.getClassCheckItem("Add Memristor", "MemristorElm"));
        menu3.add(this.getClassCheckItem("Add Spark Gap", "SparkGapElm"));
        Menu menu4 = new Menu("Inputs/Outputs");
        this.mainMenu.add(menu4);
        menu4.add(this.getClassCheckItem("Add Ground", "GroundElm"));
        menu4.add(this.getClassCheckItem("Add Voltage Source (2-terminal)", "DCVoltageElm"));
        menu4.add(this.getClassCheckItem("Add A/C Source (2-terminal)", "ACVoltageElm"));
        menu4.add(this.getClassCheckItem("Add Voltage Source (1-terminal)", "RailElm"));
        menu4.add(this.getClassCheckItem("Add A/C Source (1-terminal)", "ACRailElm"));
        menu4.add(this.getClassCheckItem("Add Square Wave (1-terminal)", "SquareRailElm"));
        menu4.add(this.getClassCheckItem("Add Analog Output", "OutputElm"));
        menu4.add(this.getClassCheckItem("Add Logic Input", "LogicInputElm"));
        menu4.add(this.getClassCheckItem("Add Logic Output", "LogicOutputElm"));
        menu4.add(this.getClassCheckItem("Add Clock", "ClockElm"));
        menu4.add(this.getClassCheckItem("Add A/C Sweep", "SweepElm"));
        menu4.add(this.getClassCheckItem("Add Var. Voltage", "VarRailElm"));
        menu4.add(this.getClassCheckItem("Add Antenna", "AntennaElm"));
        menu4.add(this.getClassCheckItem("Add Current Source", "CurrentElm"));
        menu4.add(this.getClassCheckItem("Add LED", "LEDElm"));
        menu4.add(this.getClassCheckItem("Add Lamp", "LampElm"));
        Menu menu5 = new Menu("Active Components");
        this.mainMenu.add(menu5);
        menu5.add(this.getClassCheckItem("Add Diode", "DiodeElm"));
        menu5.add(this.getClassCheckItem("Add Zener Diode", "ZenerElm"));
        menu5.add(this.getClassCheckItem("Add Transistor (bipolar, NPN)", "NTransistorElm"));
        menu5.add(this.getClassCheckItem("Add Transistor (bipolar, PNP)", "PTransistorElm"));
        menu5.add(this.getClassCheckItem("Add Op Amp (- on top)", "OpAmpElm"));
        menu5.add(this.getClassCheckItem("Add Op Amp (+ on top)", "OpAmpSwapElm"));
        menu5.add(this.getClassCheckItem("Add MOSFET (n-channel)", "NMosfetElm"));
        menu5.add(this.getClassCheckItem("Add MOSFET (p-channel)", "PMosfetElm"));
        menu5.add(this.getClassCheckItem("Add JFET (n-channel)", "NJfetElm"));
        menu5.add(this.getClassCheckItem("Add JFET (p-channel)", "PJfetElm"));
        menu5.add(this.getClassCheckItem("Add Analog Switch (SPST)", "AnalogSwitchElm"));
        menu5.add(this.getClassCheckItem("Add Analog Switch (SPDT)", "AnalogSwitch2Elm"));
        menu5.add(this.getClassCheckItem("Add SCR", "SCRElm"));
        menu5.add(this.getClassCheckItem("Add Tunnel Diode", "TunnelDiodeElm"));
        menu5.add(this.getClassCheckItem("Add Triode", "TriodeElm"));
        menu5.add(this.getClassCheckItem("Add CCII+", "CC2Elm"));
        menu5.add(this.getClassCheckItem("Add CCII-", "CC2NegElm"));
        Menu menu6 = new Menu("Logic Gates");
        this.mainMenu.add(menu6);
        menu6.add(this.getClassCheckItem("Add Inverter", "InverterElm"));
        menu6.add(this.getClassCheckItem("Add NAND Gate", "NandGateElm"));
        menu6.add(this.getClassCheckItem("Add NOR Gate", "NorGateElm"));
        menu6.add(this.getClassCheckItem("Add AND Gate", "AndGateElm"));
        menu6.add(this.getClassCheckItem("Add OR Gate", "OrGateElm"));
        menu6.add(this.getClassCheckItem("Add XOR Gate", "XorGateElm"));
        Menu menu7 = new Menu("Chips");
        this.mainMenu.add(menu7);
        menu7.add(this.getClassCheckItem("Add D Flip-Flop", "DFlipFlopElm"));
        menu7.add(this.getClassCheckItem("Add JK Flip-Flop", "JKFlipFlopElm"));
        menu7.add(this.getClassCheckItem("Add 7 Segment LED", "SevenSegElm"));
        menu7.add(this.getClassCheckItem("Add VCO", "VCOElm"));
        menu7.add(this.getClassCheckItem("Add Phase Comparator", "PhaseCompElm"));
        menu7.add(this.getClassCheckItem("Add Counter", "CounterElm"));
        menu7.add(this.getClassCheckItem("Add Decade Counter", "DecadeElm"));
        menu7.add(this.getClassCheckItem("Add 555 Timer", "TimerElm"));
        menu7.add(this.getClassCheckItem("Add DAC", "DACElm"));
        menu7.add(this.getClassCheckItem("Add ADC", "ADCElm"));
        menu7.add(this.getClassCheckItem("Add Latch", "LatchElm"));
        Menu menu8 = new Menu("Other");
        this.mainMenu.add(menu8);
        menu8.add(this.getClassCheckItem("Add Text", "TextElm"));
        menu8.add(this.getClassCheckItem("Add Scope Probe", "ProbeElm"));
        menu8.add(this.getCheckItem("Drag All (Alt-drag)", "DragAll"));
        menu8.add(this.getCheckItem(this.isMac ? "Drag Row (Alt-S-drag, S-right)" : "Drag Row (S-right)", "DragRow"));
        menu8.add(this.getCheckItem(this.isMac ? "Drag Column (Alt-\u2318-drag, \u2318-right)" : "Drag Column (C-right)", "DragColumn"));
        menu8.add(this.getCheckItem("Drag Selected", "DragSelected"));
        menu8.add(this.getCheckItem("Drag Post (" + this.ctrlMetaKey + "-drag)", "DragPost"));
        this.mainMenu.add(this.getCheckItem("Select/Drag Selected (space or Shift-drag)", "Select"));
        main.add(this.mainMenu);
        this.resetButton = new Button("Reset");
        main.add(this.resetButton);
        this.resetButton.addActionListener(this);
        this.dumpMatrixButton = new Button("Dump Matrix");
        this.dumpMatrixButton.addActionListener(this);
        this.stoppedCheck = new Checkbox("Stopped");
        this.stoppedCheck.addItemListener(this);
        main.add(this.stoppedCheck);
        main.add(new Label("Simulation Speed", 1));
        this.speedBar = new Scrollbar(0, 3, 1, 0, 260);
        main.add(this.speedBar);
        this.speedBar.addAdjustmentListener(this);
        main.add(new Label("Current Speed", 1));
        this.currentBar = new Scrollbar(0, 50, 1, 1, 100);
        this.currentBar.addAdjustmentListener(this);
        main.add(this.currentBar);
        this.powerLabel = new Label("Power Brightness", 1);
        main.add(this.powerLabel);
        this.powerBar = new Scrollbar(0, 50, 1, 1, 100);
        main.add(this.powerBar);
        this.powerBar.addAdjustmentListener(this);
        this.powerBar.disable();
        this.powerLabel.disable();
        main.add(new Label("www.falstad.com"));
        if (this.useFrame) {
            main.add(new Label(""));
        }
        Font font = new Font("SansSerif", 0, 10);
        Label label = new Label("Current Circuit:");
        label.setFont(font);
        this.titleLabel = new Label("Label");
        this.titleLabel.setFont(font);
        if (this.useFrame) {
            main.add(label);
            main.add(this.titleLabel);
        }
        this.setGrid();
        this.elmList = new Vector();
        this.setupList = new Vector();
        this.undoStack = new Vector();
        this.redoStack = new Vector();
        this.scopes = new Scope[20];
        this.scopeColCount = new int[20];
        this.scopeCount = 0;
        this.random = new Random();
        this.cv.setBackground(Color.black);
        this.cv.setForeground(Color.lightGray);
        this.elmMenu = new PopupMenu();
        this.elmEditMenuItem = this.getMenuItem("Edit");
        this.elmMenu.add(this.elmEditMenuItem);
        this.elmScopeMenuItem = this.getMenuItem("View in Scope");
        this.elmMenu.add(this.elmScopeMenuItem);
        this.elmCutMenuItem = this.getMenuItem("Cut");
        this.elmMenu.add(this.elmCutMenuItem);
        this.elmCopyMenuItem = this.getMenuItem("Copy");
        this.elmMenu.add(this.elmCopyMenuItem);
        this.elmDeleteMenuItem = this.getMenuItem("Delete");
        this.elmMenu.add(this.elmDeleteMenuItem);
        main.add(this.elmMenu);
        this.scopeMenu = this.buildScopeMenu(false);
        this.transScopeMenu = this.buildScopeMenu(true);
        this.getSetupList(menu2, false);
        if (this.useFrame) {
            this.setMenuBar(menuBar);
        }
        if (this.stopMessage == null && this.startCircuit != null) {
            this.readSetupFile(this.startCircuit, this.startLabel);
        }
        if (this.useFrame) {
            Dimension dimension = this.getToolkit().getScreenSize();
            this.resize(860, 640);
            this.handleResize();
            Dimension dimension2 = this.getSize();
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            this.show();
        } else {
            if (!this.powerCheckItem.getState()) {
                main.remove(this.powerBar);
                main.remove(this.powerLabel);
                main.validate();
            }
            this.hide();
            this.handleResize();
            this.applet.validate();
        }
        main.requestFocus();
    }

    public void triggerShow() {
        if (!this.shown) {
            this.show();
        }
        this.shown = true;
    }

    PopupMenu buildScopeMenu(boolean bl) {
        PopupMenu popupMenu = new PopupMenu();
        popupMenu.add(this.getMenuItem("Remove", "remove"));
        popupMenu.add(this.getMenuItem("Speed 2x", "speed2"));
        popupMenu.add(this.getMenuItem("Speed 1/2x", "speed1/2"));
        popupMenu.add(this.getMenuItem("Scale 2x", "scale"));
        popupMenu.add(this.getMenuItem("Max Scale", "maxscale"));
        popupMenu.add(this.getMenuItem("Stack", "stack"));
        popupMenu.add(this.getMenuItem("Unstack", "unstack"));
        popupMenu.add(this.getMenuItem("Reset", "reset"));
        if (bl) {
            this.scopeIbMenuItem = this.getCheckItem("Show Ib");
            popupMenu.add(this.scopeIbMenuItem);
            this.scopeIcMenuItem = this.getCheckItem("Show Ic");
            popupMenu.add(this.scopeIcMenuItem);
            this.scopeIeMenuItem = this.getCheckItem("Show Ie");
            popupMenu.add(this.scopeIeMenuItem);
            this.scopeVbeMenuItem = this.getCheckItem("Show Vbe");
            popupMenu.add(this.scopeVbeMenuItem);
            this.scopeVbcMenuItem = this.getCheckItem("Show Vbc");
            popupMenu.add(this.scopeVbcMenuItem);
            this.scopeVceMenuItem = this.getCheckItem("Show Vce");
            popupMenu.add(this.scopeVceMenuItem);
            this.scopeVceIcMenuItem = this.getCheckItem("Show Vce vs Ic");
            popupMenu.add(this.scopeVceIcMenuItem);
        } else {
            this.scopeVMenuItem = this.getCheckItem("Show Voltage");
            popupMenu.add(this.scopeVMenuItem);
            this.scopeIMenuItem = this.getCheckItem("Show Current");
            popupMenu.add(this.scopeIMenuItem);
            this.scopePowerMenuItem = this.getCheckItem("Show Power Consumed");
            popupMenu.add(this.scopePowerMenuItem);
            this.scopeMaxMenuItem = this.getCheckItem("Show Peak Value");
            popupMenu.add(this.scopeMaxMenuItem);
            this.scopeMinMenuItem = this.getCheckItem("Show Negative Peak Value");
            popupMenu.add(this.scopeMinMenuItem);
            this.scopeFreqMenuItem = this.getCheckItem("Show Frequency");
            popupMenu.add(this.scopeFreqMenuItem);
            this.scopeVIMenuItem = this.getCheckItem("Show V vs I");
            popupMenu.add(this.scopeVIMenuItem);
            this.scopeXYMenuItem = this.getCheckItem("Plot X/Y");
            popupMenu.add(this.scopeXYMenuItem);
            this.scopeSelectYMenuItem = this.getMenuItem("Select Y", "selecty");
            popupMenu.add(this.scopeSelectYMenuItem);
            this.scopeResistMenuItem = this.getCheckItem("Show Resistance");
            popupMenu.add(this.scopeResistMenuItem);
        }
        main.add(popupMenu);
        return popupMenu;
    }

    MenuItem getMenuItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        return menuItem;
    }

    MenuItem getMenuItem(String string, String string2) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.setActionCommand(string2);
        menuItem.addActionListener(this);
        return menuItem;
    }

    CheckboxMenuItem getCheckItem(String string) {
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
        checkboxMenuItem.addItemListener(this);
        checkboxMenuItem.setActionCommand("");
        return checkboxMenuItem;
    }

    CheckboxMenuItem getClassCheckItem(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string2);
            CircuitElm circuitElm = this.constructElement(clazz, 0, 0);
            this.register(clazz, circuitElm);
            int n = 0;
            if (circuitElm.needsShortcut() && circuitElm.getDumpClass() == clazz) {
                n = circuitElm.getDumpType();
                string = string + " (" + (char)n + ")";
            }
            circuitElm.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.getCheckItem(string, string2);
    }

    CheckboxMenuItem getCheckItem(String string, String string2) {
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
        checkboxMenuItem.addItemListener(this);
        checkboxMenuItem.setActionCommand(string2);
        return checkboxMenuItem;
    }

    void register(Class clazz, CircuitElm circuitElm) {
        int n = circuitElm.getDumpType();
        if (n == 0) {
            System.out.println("no dump type: " + clazz);
            return;
        }
        Class clazz2 = circuitElm.getDumpClass();
        if (this.dumpTypes[n] == clazz2) {
            return;
        }
        if (this.dumpTypes[n] != null) {
            System.out.println("dump type conflict: " + clazz + " " + this.dumpTypes[n]);
            return;
        }
        this.dumpTypes[n] = clazz2;
    }

    void handleResize() {
        int n;
        this.winSize = this.cv.getSize();
        if (this.winSize.width == 0) {
            return;
        }
        this.dbimage = main.createImage(this.winSize.width, this.winSize.height);
        int n2 = this.winSize.height / 5;
        this.circuitArea = new Rectangle(0, 0, this.winSize.width, this.winSize.height - n2);
        int n3 = 1000;
        int n4 = 0;
        int n5 = 1000;
        int n6 = 0;
        for (n = 0; n != this.elmList.size(); ++n) {
            CircuitElm circuitElm = this.getElm(n);
            if (!circuitElm.isCenteredText()) {
                n3 = this.min(circuitElm.x, this.min(circuitElm.x2, n3));
                n4 = this.max(circuitElm.x, this.max(circuitElm.x2, n4));
            }
            n5 = this.min(circuitElm.y, this.min(circuitElm.y2, n5));
            n6 = this.max(circuitElm.y, this.max(circuitElm.y2, n6));
        }
        int n7 = this.gridMask & (this.circuitArea.width - (n4 - n3)) / 2 - n3;
        int n8 = this.gridMask & (this.circuitArea.height - (n6 - n5)) / 2 - n5;
        if (n7 + n3 < 0) {
            n7 = this.gridMask & -n3;
        }
        if (n8 + n5 < 0) {
            n8 = this.gridMask & -n5;
        }
        for (n = 0; n != this.elmList.size(); ++n) {
            CircuitElm circuitElm = this.getElm(n);
            circuitElm.move(n7, n8);
        }
        this.needAnalyze();
        this.circuitBottom = 0;
    }

    void destroyFrame() {
        if (this.applet == null) {
            this.dispose();
        } else {
            this.applet.destroyFrame();
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.destroyFrame();
            return true;
        }
        return super.handleEvent(event);
    }

    public void paint(Graphics graphics) {
        this.cv.repaint();
    }

    public void updateCircuit(Graphics graphics) {
        int n;
        int n2;
        if (this.winSize == null || this.winSize.width == 0) {
            return;
        }
        if (this.analyzeFlag) {
            this.analyzeCircuit();
            this.analyzeFlag = false;
        }
        if (editDialog != null && CirSim.editDialog.elm instanceof CircuitElm) {
            this.mouseElm = (CircuitElm)CirSim.editDialog.elm;
        }
        CircuitElm circuitElm = this.mouseElm;
        if (this.mouseElm == null) {
            this.mouseElm = this.stopElm;
        }
        this.setupScopes();
        Graphics graphics2 = null;
        graphics2 = this.dbimage.getGraphics();
        CircuitElm.selectColor = Color.cyan;
        if (this.printableCheckItem.getState()) {
            CircuitElm.whiteColor = Color.black;
            CircuitElm.lightGrayColor = Color.black;
            graphics2.setColor(Color.white);
        } else {
            CircuitElm.whiteColor = Color.white;
            CircuitElm.lightGrayColor = Color.lightGray;
            graphics2.setColor(Color.black);
        }
        graphics2.fillRect(0, 0, this.winSize.width, this.winSize.height);
        if (!this.stoppedCheck.getState()) {
            try {
                this.runCircuit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.analyzeFlag = true;
                this.cv.repaint();
                return;
            }
        }
        if (!this.stoppedCheck.getState()) {
            long l = System.currentTimeMillis();
            if (this.lastTime != 0L) {
                n2 = (int)(l - this.lastTime);
                double d = this.currentBar.getValue();
                d = Math.exp(d / 3.5 - 14.2);
                CircuitElm.currentMult = 1.7 * (double)n2 * d;
                if (!this.conventionCheckItem.getState()) {
                    CircuitElm.currentMult = -CircuitElm.currentMult;
                }
            }
            if (l - this.secTime >= 1000L) {
                this.framerate = this.frames;
                this.steprate = this.steps;
                this.frames = 0;
                this.steps = 0;
                this.secTime = l;
            }
            this.lastTime = l;
        } else {
            this.lastTime = 0L;
        }
        CircuitElm.powerMult = Math.exp((double)this.powerBar.getValue() / 4.762 - 7.0);
        Font font = graphics2.getFont();
        for (n = 0; n != this.elmList.size(); ++n) {
            if (this.powerCheckItem.getState()) {
                graphics2.setColor(Color.gray);
            }
            this.getElm(n).draw(graphics2);
        }
        if (this.tempMouseMode == 2 || this.tempMouseMode == 3 || this.tempMouseMode == 5 || this.tempMouseMode == 4) {
            for (n = 0; n != this.elmList.size(); ++n) {
                CircuitElm circuitElm2 = this.getElm(n);
                circuitElm2.drawPost(graphics2, circuitElm2.x, circuitElm2.y);
                circuitElm2.drawPost(graphics2, circuitElm2.x2, circuitElm2.y2);
            }
        }
        n2 = 0;
        for (n = 0; n != this.nodeList.size(); ++n) {
            CircuitNode circuitNode = this.getCircuitNode(n);
            if (circuitNode.internal || circuitNode.links.size() != 1) continue;
            int n3 = 0;
            CircuitNodeLink circuitNodeLink = (CircuitNodeLink)circuitNode.links.elementAt(0);
            for (int i = 0; i != this.elmList.size(); ++i) {
                if (circuitNodeLink.elm == this.getElm(i) || !this.getElm((int)i).boundingBox.contains(circuitNode.x, circuitNode.y)) continue;
                ++n3;
            }
            if (n3 <= 0) continue;
            graphics2.setColor(Color.red);
            graphics2.fillOval(circuitNode.x - 3, circuitNode.y - 3, 7, 7);
            ++n2;
        }
        if (this.dragElm != null && (this.dragElm.x != this.dragElm.x2 || this.dragElm.y != this.dragElm.y2)) {
            this.dragElm.draw(graphics2);
        }
        graphics2.setFont(font);
        int n4 = this.scopeCount;
        if (this.stopMessage != null) {
            n4 = 0;
        }
        for (n = 0; n != n4; ++n) {
            this.scopes[n].draw(graphics2);
        }
        graphics2.setColor(CircuitElm.whiteColor);
        if (this.stopMessage != null) {
            graphics2.drawString(this.stopMessage, 10, this.circuitArea.height);
        } else {
            if (this.circuitBottom == 0) {
                this.calcCircuitBottom();
            }
            String[] stringArray = new String[10];
            if (this.mouseElm != null) {
                if (this.mousePost == -1) {
                    this.mouseElm.getInfo(stringArray);
                } else {
                    stringArray[0] = "V = " + CircuitElm.getUnitText(this.mouseElm.getPostVoltage(this.mousePost), "V");
                }
            } else {
                CircuitElm.showFormat.setMinimumFractionDigits(2);
                stringArray[0] = "t = " + CircuitElm.getUnitText(this.t, "s");
                CircuitElm.showFormat.setMinimumFractionDigits(0);
            }
            if (this.hintType != -1) {
                n = 0;
                while (stringArray[n] != null) {
                    ++n;
                }
                String string = this.getHint();
                if (string == null) {
                    this.hintType = -1;
                } else {
                    stringArray[n] = string;
                }
            }
            int n5 = 0;
            if (n4 != 0) {
                n5 = this.scopes[n4 - 1].rightEdge() + 20;
            }
            n5 = this.max(n5, this.winSize.width * 2 / 3);
            n = 0;
            while (stringArray[n] != null) {
                ++n;
            }
            if (n2 > 0) {
                stringArray[n++] = n2 + (n2 == 1 ? " bad connection" : " bad connections");
            }
            int n6 = this.winSize.height - 15 * n - 5;
            n6 = this.min(n6, this.circuitArea.height);
            n6 = this.max(n6, this.circuitBottom);
            n = 0;
            while (stringArray[n] != null) {
                graphics2.drawString(stringArray[n], n5, n6 + 15 * (n + 1));
                ++n;
            }
        }
        if (this.selectedArea != null) {
            graphics2.setColor(CircuitElm.selectColor);
            graphics2.drawRect(this.selectedArea.x, this.selectedArea.y, this.selectedArea.width, this.selectedArea.height);
        }
        this.mouseElm = circuitElm;
        ++this.frames;
        graphics.drawImage(this.dbimage, 0, 0, this);
        if (!this.stoppedCheck.getState() && this.circuitMatrix != null) {
            long l = 20L - (System.currentTimeMillis() - this.lastFrameTime);
            if (l > 0L) {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.cv.repaint(0L);
        }
        this.lastFrameTime = this.lastTime;
    }

    void setupScopes() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = -1;
        for (n4 = 0; n4 < this.scopeCount; ++n4) {
            if (this.locateElm(this.scopes[n4].elm) < 0) {
                this.scopes[n4].setElm(null);
            }
            if (this.scopes[n4].elm == null) {
                for (n3 = n4; n3 != this.scopeCount; ++n3) {
                    this.scopes[n3] = this.scopes[n3 + 1];
                }
                --this.scopeCount;
                --n4;
                continue;
            }
            if (this.scopes[n4].position > n5 + 1) {
                this.scopes[n4].position = n5 + 1;
            }
            n5 = this.scopes[n4].position;
        }
        while (this.scopeCount > 0 && this.scopes[this.scopeCount - 1].elm == null) {
            --this.scopeCount;
        }
        n3 = this.winSize.height - this.circuitArea.height;
        n5 = 0;
        for (n4 = 0; n4 != this.scopeCount; ++n4) {
            this.scopeColCount[n4] = 0;
        }
        for (n4 = 0; n4 != this.scopeCount; ++n4) {
            n5 = this.max(this.scopes[n4].position, n5);
            int n6 = this.scopes[n4].position;
            this.scopeColCount[n6] = this.scopeColCount[n6] + 1;
        }
        int n7 = n5 + 1;
        int n8 = 120;
        if (n7 <= 2) {
            n8 = n8 * 3 / 2;
        }
        if ((n2 = (this.winSize.width - n8) / n7) < (n = 10) * 2) {
            n2 = n * 2;
        }
        n5 = -1;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (n4 = 0; n4 != this.scopeCount; ++n4) {
            Scope scope = this.scopes[n4];
            if (scope.position > n5) {
                n5 = scope.position;
                n9 = n3 / this.scopeColCount[n5];
                n10 = 0;
                n11 = scope.speed;
            }
            if (scope.speed != n11) {
                scope.speed = n11;
                scope.resetGraph();
            }
            Rectangle rectangle = new Rectangle(n5 * n2, this.winSize.height - n3 + n9 * n10, n2 - n, n9);
            ++n10;
            if (rectangle.equals(scope.rect)) continue;
            scope.setRect(rectangle);
        }
    }

    String getHint() {
        CircuitElm circuitElm = this.getElm(this.hintItem1);
        CircuitElm circuitElm2 = this.getElm(this.hintItem2);
        if (circuitElm == null || circuitElm2 == null) {
            return null;
        }
        if (this.hintType == 1) {
            if (!(circuitElm instanceof InductorElm)) {
                return null;
            }
            if (!(circuitElm2 instanceof CapacitorElm)) {
                return null;
            }
            InductorElm inductorElm = (InductorElm)circuitElm;
            CapacitorElm capacitorElm = (CapacitorElm)circuitElm2;
            return "res.f = " + CircuitElm.getUnitText(1.0 / (Math.PI * 2 * Math.sqrt(inductorElm.inductance * capacitorElm.capacitance)), "Hz");
        }
        if (this.hintType == 2) {
            if (!(circuitElm instanceof ResistorElm)) {
                return null;
            }
            if (!(circuitElm2 instanceof CapacitorElm)) {
                return null;
            }
            ResistorElm resistorElm = (ResistorElm)circuitElm;
            CapacitorElm capacitorElm = (CapacitorElm)circuitElm2;
            return "RC = " + CircuitElm.getUnitText(resistorElm.resistance * capacitorElm.capacitance, "s");
        }
        if (this.hintType == 3) {
            if (!(circuitElm instanceof ResistorElm)) {
                return null;
            }
            if (!(circuitElm2 instanceof CapacitorElm)) {
                return null;
            }
            ResistorElm resistorElm = (ResistorElm)circuitElm;
            CapacitorElm capacitorElm = (CapacitorElm)circuitElm2;
            return "f.3db = " + CircuitElm.getUnitText(1.0 / (Math.PI * 2 * resistorElm.resistance * capacitorElm.capacitance), "Hz");
        }
        if (this.hintType == 5) {
            if (!(circuitElm instanceof ResistorElm)) {
                return null;
            }
            if (!(circuitElm2 instanceof InductorElm)) {
                return null;
            }
            ResistorElm resistorElm = (ResistorElm)circuitElm;
            InductorElm inductorElm = (InductorElm)circuitElm2;
            return "f.3db = " + CircuitElm.getUnitText(resistorElm.resistance / (Math.PI * 2 * inductorElm.inductance), "Hz");
        }
        if (this.hintType == 4) {
            if (!(circuitElm instanceof ResistorElm)) {
                return null;
            }
            if (!(circuitElm2 instanceof CapacitorElm)) {
                return null;
            }
            ResistorElm resistorElm = (ResistorElm)circuitElm;
            CapacitorElm capacitorElm = (CapacitorElm)circuitElm2;
            return "fc = " + CircuitElm.getUnitText(1.0 / (Math.PI * 2 * resistorElm.resistance * capacitorElm.capacitance), "Hz");
        }
        return null;
    }

    public void toggleSwitch(int n) {
        for (int i = 0; i != this.elmList.size(); ++i) {
            CircuitElm circuitElm = this.getElm(i);
            if (!(circuitElm instanceof SwitchElm) || --n != 0) continue;
            ((SwitchElm)circuitElm).toggle();
            this.analyzeFlag = true;
            this.cv.repaint();
            return;
        }
    }

    void needAnalyze() {
        this.analyzeFlag = true;
        this.cv.repaint();
    }

    public CircuitNode getCircuitNode(int n) {
        if (n >= this.nodeList.size()) {
            return null;
        }
        return (CircuitNode)this.nodeList.elementAt(n);
    }

    public CircuitElm getElm(int n) {
        if (n >= this.elmList.size()) {
            return null;
        }
        return (CircuitElm)this.elmList.elementAt(n);
    }

    void analyzeCircuit() {
        int n;
        Object object;
        int n2;
        this.calcCircuitBottom();
        if (this.elmList.isEmpty()) {
            return;
        }
        this.stopMessage = null;
        this.stopElm = null;
        int n3 = 0;
        this.nodeList = new Vector();
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = null;
        for (n2 = 0; n2 != this.elmList.size(); ++n2) {
            object = this.getElm(n2);
            if (object instanceof GroundElm) {
                bl = true;
                break;
            }
            if (object instanceof RailElm) {
                bl2 = true;
            }
            if (object2 != null || !(object instanceof VoltageElm)) continue;
            object2 = object;
        }
        if (!bl && object2 != null && !bl2) {
            object = new CircuitNode();
            Point point = ((CircuitElm)object2).getPost(0);
            ((CircuitNode)object).x = point.x;
            ((CircuitNode)object).y = point.y;
            this.nodeList.addElement(object);
        } else {
            object = new CircuitNode();
            ((CircuitNode)object).y = -1;
            ((CircuitNode)object).x = -1;
            this.nodeList.addElement(object);
        }
        for (n2 = 0; n2 != this.elmList.size(); ++n2) {
            Object object3;
            object = this.getElm(n2);
            int n4 = ((CircuitElm)object).getInternalNodeCount();
            int n5 = ((CircuitElm)object).getVoltageSourceCount();
            int n6 = ((CircuitElm)object).getPostCount();
            for (n = 0; n != n6; ++n) {
                Object object4;
                int n7;
                object3 = ((CircuitElm)object).getPost(n);
                for (n7 = 0; n7 != this.nodeList.size(); ++n7) {
                    object4 = this.getCircuitNode(n7);
                    if (((Point)object3).x == ((CircuitNode)object4).x && ((Point)object3).y == ((CircuitNode)object4).y) break;
                }
                if (n7 == this.nodeList.size()) {
                    object4 = new CircuitNode();
                    ((CircuitNode)object4).x = ((Point)object3).x;
                    ((CircuitNode)object4).y = ((Point)object3).y;
                    CircuitNodeLink circuitNodeLink = new CircuitNodeLink();
                    circuitNodeLink.num = n;
                    circuitNodeLink.elm = object;
                    ((CircuitNode)object4).links.addElement(circuitNodeLink);
                    ((CircuitElm)object).setNode(n, this.nodeList.size());
                    this.nodeList.addElement(object4);
                    continue;
                }
                object4 = new CircuitNodeLink();
                ((CircuitNodeLink)object4).num = n;
                ((CircuitNodeLink)object4).elm = object;
                this.getCircuitNode((int)n7).links.addElement(object4);
                ((CircuitElm)object).setNode(n, n7);
                if (n7 != 0) continue;
                ((CircuitElm)object).setNodeVoltage(n, 0.0);
            }
            for (n = 0; n != n4; ++n) {
                object3 = new CircuitNode();
                ((CircuitNode)object3).y = -1;
                ((CircuitNode)object3).x = -1;
                ((CircuitNode)object3).internal = true;
                CircuitNodeLink circuitNodeLink = new CircuitNodeLink();
                circuitNodeLink.num = n + n6;
                circuitNodeLink.elm = object;
                ((CircuitNode)object3).links.addElement(circuitNodeLink);
                ((CircuitElm)object).setNode(circuitNodeLink.num, this.nodeList.size());
                this.nodeList.addElement(object3);
            }
            n3 += n5;
        }
        this.voltageSources = new CircuitElm[n3];
        n3 = 0;
        this.circuitNonLinear = false;
        for (n2 = 0; n2 != this.elmList.size(); ++n2) {
            object = this.getElm(n2);
            if (((CircuitElm)object).nonLinear()) {
                this.circuitNonLinear = true;
            }
            int n8 = ((CircuitElm)object).getVoltageSourceCount();
            for (n = 0; n != n8; ++n) {
                this.voltageSources[n3] = object;
                ((CircuitElm)object).setVoltageSource(n, n3++);
            }
        }
        this.voltageSourceCount = n3;
        int n9 = this.nodeList.size() - 1 + n3;
        this.circuitMatrix = new double[n9][n9];
        this.circuitRightSide = new double[n9];
        this.origMatrix = new double[n9][n9];
        this.origRightSide = new double[n9];
        this.circuitMatrixSize = this.circuitMatrixFullSize = n9;
        this.circuitRowInfo = new RowInfo[n9];
        this.circuitPermute = new int[n9];
        boolean bl3 = false;
        for (n2 = 0; n2 != n9; ++n2) {
            this.circuitRowInfo[n2] = new RowInfo();
        }
        this.circuitNeedsMap = false;
        for (n2 = 0; n2 != this.elmList.size(); ++n2) {
            CircuitElm circuitElm = this.getElm(n2);
            circuitElm.stamp();
        }
        boolean[] blArray = new boolean[this.nodeList.size()];
        boolean[] blArray2 = new boolean[this.nodeList.size()];
        boolean bl4 = true;
        blArray[0] = true;
        block9: while (bl4) {
            bl4 = false;
            for (n2 = 0; n2 != this.elmList.size(); ++n2) {
                CircuitElm circuitElm = this.getElm(n2);
                for (n = 0; n < circuitElm.getPostCount(); ++n) {
                    if (!blArray[circuitElm.getNode(n)]) {
                        if (!circuitElm.hasGroundConnection(n)) continue;
                        bl4 = true;
                        blArray[circuitElm.getNode((int)n)] = true;
                        continue;
                    }
                    for (int i = 0; i != circuitElm.getPostCount(); ++i) {
                        if (n == i) continue;
                        int n10 = circuitElm.getNode(i);
                        if (!circuitElm.getConnection(n, i) || blArray[n10]) continue;
                        blArray[n10] = true;
                        bl4 = true;
                    }
                }
            }
            if (bl4) continue;
            for (n2 = 0; n2 != this.nodeList.size(); ++n2) {
                if (blArray[n2] || this.getCircuitNode((int)n2).internal) continue;
                System.out.println("node " + n2 + " unconnected");
                this.stampResistor(0, n2, 1.0E8);
                blArray[n2] = true;
                bl4 = true;
                continue block9;
            }
        }
        for (n2 = 0; n2 != this.elmList.size(); ++n2) {
            FindPathInfo findPathInfo;
            CircuitElm circuitElm = this.getElm(n2);
            if (circuitElm instanceof InductorElm && !(findPathInfo = new FindPathInfo(1, circuitElm, circuitElm.getNode(1))).findPath(circuitElm.getNode(0), 5) && !findPathInfo.findPath(circuitElm.getNode(0))) {
                System.out.println(circuitElm + " no path");
                circuitElm.reset();
            }
            if (circuitElm instanceof CurrentElm && !(findPathInfo = new FindPathInfo(1, circuitElm, circuitElm.getNode(1))).findPath(circuitElm.getNode(0))) {
                this.stop("No path for current source!", circuitElm);
                return;
            }
            if ((circuitElm instanceof VoltageElm && circuitElm.getPostCount() == 2 || circuitElm instanceof WireElm) && (findPathInfo = new FindPathInfo(2, circuitElm, circuitElm.getNode(1))).findPath(circuitElm.getNode(0))) {
                this.stop("Voltage source/wire loop with no resistance!", circuitElm);
                return;
            }
            if (!(circuitElm instanceof CapacitorElm)) continue;
            findPathInfo = new FindPathInfo(3, circuitElm, circuitElm.getNode(1));
            if (findPathInfo.findPath(circuitElm.getNode(0))) {
                System.out.println(circuitElm + " shorted");
                circuitElm.reset();
                continue;
            }
            findPathInfo = new FindPathInfo(4, circuitElm, circuitElm.getNode(1));
            if (!findPathInfo.findPath(circuitElm.getNode(0))) continue;
            this.stop("Capacitor loop with no resistance!", circuitElm);
            return;
        }
        for (n2 = 0; n2 != n9; ++n2) {
            int n11;
            int n12 = -1;
            int n13 = -1;
            double d = 0.0;
            RowInfo rowInfo = this.circuitRowInfo[n2];
            if (rowInfo.lsChanges || rowInfo.dropRow || rowInfo.rsChanges) continue;
            double d2 = 0.0;
            for (n = 0; n != n9; ++n) {
                double d3 = this.circuitMatrix[n2][n];
                if (this.circuitRowInfo[n].type == 1) {
                    d2 -= this.circuitRowInfo[n].value * d3;
                    continue;
                }
                if (d3 == 0.0) continue;
                if (n13 == -1) {
                    n13 = n;
                    d = d3;
                    continue;
                }
                if (n12 != -1 || d3 != -d) break;
                n12 = n;
            }
            if (n != n9) continue;
            if (n13 == -1) {
                this.stop("Matrix error", null);
                return;
            }
            RowInfo rowInfo2 = this.circuitRowInfo[n13];
            if (n12 == -1) {
                for (n11 = 0; rowInfo2.type == 2 && n11 < 100; ++n11) {
                    n13 = rowInfo2.nodeEq;
                    rowInfo2 = this.circuitRowInfo[n13];
                }
                if (rowInfo2.type == 2) {
                    rowInfo2.type = 0;
                    continue;
                }
                if (rowInfo2.type != 0) {
                    System.out.println("type already " + rowInfo2.type + " for " + n13 + "!");
                    continue;
                }
                rowInfo2.type = 1;
                rowInfo2.value = (this.circuitRightSide[n2] + d2) / d;
                this.circuitRowInfo[n2].dropRow = true;
                n2 = -1;
                continue;
            }
            if (this.circuitRightSide[n2] + d2 != 0.0) continue;
            if (rowInfo2.type != 0) {
                n11 = n12;
                n12 = n13;
                n13 = n11;
                rowInfo2 = this.circuitRowInfo[n13];
                if (rowInfo2.type != 0) {
                    System.out.println("swap failed");
                    continue;
                }
            }
            rowInfo2.type = 2;
            rowInfo2.nodeEq = n12;
            this.circuitRowInfo[n2].dropRow = true;
        }
        int n14 = 0;
        for (n2 = 0; n2 != n9; ++n2) {
            RowInfo rowInfo = this.circuitRowInfo[n2];
            if (rowInfo.type == 0) {
                rowInfo.mapCol = n14++;
                continue;
            }
            if (rowInfo.type == 2) {
                RowInfo rowInfo3 = null;
                for (n = 0; n != 100; ++n) {
                    rowInfo3 = this.circuitRowInfo[rowInfo.nodeEq];
                    if (rowInfo3.type != 2 || n2 == rowInfo3.nodeEq) break;
                    rowInfo.nodeEq = rowInfo3.nodeEq;
                }
            }
            if (rowInfo.type != 1) continue;
            rowInfo.mapCol = -1;
        }
        for (n2 = 0; n2 != n9; ++n2) {
            RowInfo rowInfo = this.circuitRowInfo[n2];
            if (rowInfo.type != 2) continue;
            RowInfo rowInfo4 = this.circuitRowInfo[rowInfo.nodeEq];
            if (rowInfo4.type == 1) {
                rowInfo.type = rowInfo4.type;
                rowInfo.value = rowInfo4.value;
                rowInfo.mapCol = -1;
                continue;
            }
            rowInfo.mapCol = rowInfo4.mapCol;
        }
        int n15 = n14;
        double[][] dArray = new double[n15][n15];
        double[] dArray2 = new double[n15];
        int n16 = 0;
        for (n2 = 0; n2 != n9; ++n2) {
            RowInfo rowInfo = this.circuitRowInfo[n2];
            if (rowInfo.dropRow) {
                rowInfo.mapRow = -1;
                continue;
            }
            dArray2[n16] = this.circuitRightSide[n2];
            rowInfo.mapRow = n16;
            for (n = 0; n != n9; ++n) {
                RowInfo rowInfo5 = this.circuitRowInfo[n];
                if (rowInfo5.type == 1) {
                    int n17 = n16;
                    dArray2[n17] = dArray2[n17] - rowInfo5.value * this.circuitMatrix[n2][n];
                    continue;
                }
                double[] dArray3 = dArray[n16];
                int n18 = rowInfo5.mapCol;
                dArray3[n18] = dArray3[n18] + this.circuitMatrix[n2][n];
            }
            ++n16;
        }
        this.circuitMatrix = dArray;
        this.circuitRightSide = dArray2;
        n9 = this.circuitMatrixSize = n15;
        for (n2 = 0; n2 != n9; ++n2) {
            this.origRightSide[n2] = this.circuitRightSide[n2];
        }
        for (n2 = 0; n2 != n9; ++n2) {
            for (n = 0; n != n9; ++n) {
                this.origMatrix[n2][n] = this.circuitMatrix[n2][n];
            }
        }
        this.circuitNeedsMap = true;
        if (!this.circuitNonLinear && !this.lu_factor(this.circuitMatrix, this.circuitMatrixSize, this.circuitPermute)) {
            this.stop("Singular matrix!", null);
            return;
        }
    }

    void calcCircuitBottom() {
        this.circuitBottom = 0;
        for (int i = 0; i != this.elmList.size(); ++i) {
            Rectangle rectangle = this.getElm((int)i).boundingBox;
            int n = rectangle.height + rectangle.y;
            if (n <= this.circuitBottom) continue;
            this.circuitBottom = n;
        }
    }

    void stop(String string, CircuitElm circuitElm) {
        this.stopMessage = string;
        this.circuitMatrix = null;
        this.stopElm = circuitElm;
        this.stoppedCheck.setState(true);
        this.analyzeFlag = false;
        this.cv.repaint();
    }

    void stampVCVS(int n, int n2, double d, int n3) {
        int n4 = this.nodeList.size() + n3;
        this.stampMatrix(n4, n, d);
        this.stampMatrix(n4, n2, -d);
    }

    void stampVoltageSource(int n, int n2, int n3, double d) {
        int n4 = this.nodeList.size() + n3;
        this.stampMatrix(n4, n, -1.0);
        this.stampMatrix(n4, n2, 1.0);
        this.stampRightSide(n4, d);
        this.stampMatrix(n, n4, 1.0);
        this.stampMatrix(n2, n4, -1.0);
    }

    void stampVoltageSource(int n, int n2, int n3) {
        int n4 = this.nodeList.size() + n3;
        this.stampMatrix(n4, n, -1.0);
        this.stampMatrix(n4, n2, 1.0);
        this.stampRightSide(n4);
        this.stampMatrix(n, n4, 1.0);
        this.stampMatrix(n2, n4, -1.0);
    }

    void updateVoltageSource(int n, int n2, int n3, double d) {
        int n4 = this.nodeList.size() + n3;
        this.stampRightSide(n4, d);
    }

    void stampResistor(int n, int n2, double d) {
        double d2 = 1.0 / d;
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            System.out.print("bad resistance " + d + " " + d2 + "\n");
            int n3 = 0;
            n3 /= n3;
        }
        this.stampMatrix(n, n, d2);
        this.stampMatrix(n2, n2, d2);
        this.stampMatrix(n, n2, -d2);
        this.stampMatrix(n2, n, -d2);
    }

    void stampConductance(int n, int n2, double d) {
        this.stampMatrix(n, n, d);
        this.stampMatrix(n2, n2, d);
        this.stampMatrix(n, n2, -d);
        this.stampMatrix(n2, n, -d);
    }

    void stampVCCurrentSource(int n, int n2, int n3, int n4, double d) {
        this.stampMatrix(n, n3, d);
        this.stampMatrix(n2, n4, d);
        this.stampMatrix(n, n4, -d);
        this.stampMatrix(n2, n3, -d);
    }

    void stampCurrentSource(int n, int n2, double d) {
        this.stampRightSide(n, -d);
        this.stampRightSide(n2, d);
    }

    void stampCCCS(int n, int n2, int n3, double d) {
        int n4 = this.nodeList.size() + n3;
        this.stampMatrix(n, n4, d);
        this.stampMatrix(n2, n4, -d);
    }

    void stampMatrix(int n, int n2, double d) {
        if (n > 0 && n2 > 0) {
            if (this.circuitNeedsMap) {
                n = this.circuitRowInfo[n - 1].mapRow;
                RowInfo rowInfo = this.circuitRowInfo[n2 - 1];
                if (rowInfo.type == 1) {
                    int n3 = n;
                    this.circuitRightSide[n3] = this.circuitRightSide[n3] - d * rowInfo.value;
                    return;
                }
                n2 = rowInfo.mapCol;
            } else {
                --n;
            }
            double[] dArray = this.circuitMatrix[n];
            int n4 = --n2;
            dArray[n4] = dArray[n4] + d;
        }
    }

    void stampRightSide(int n, double d) {
        if (n > 0) {
            if (this.circuitNeedsMap) {
                n = this.circuitRowInfo[n - 1].mapRow;
            }
            int n2 = --n;
            this.circuitRightSide[n2] = this.circuitRightSide[n2] + d;
        }
    }

    void stampRightSide(int n) {
        if (n > 0) {
            this.circuitRowInfo[n - 1].rsChanges = true;
        }
    }

    void stampNonLinear(int n) {
        if (n > 0) {
            this.circuitRowInfo[n - 1].lsChanges = true;
        }
    }

    double getIterCount() {
        if (this.speedBar.getValue() == 0) {
            return 0.0;
        }
        return 0.1 * Math.exp((double)(this.speedBar.getValue() - 61) / 24.0);
    }

    void runCircuit() {
        if (this.circuitMatrix == null || this.elmList.size() == 0) {
            this.circuitMatrix = null;
            return;
        }
        boolean bl = this.dumpMatrix;
        this.dumpMatrix = false;
        long l = (long)(160.0 * this.getIterCount());
        long l2 = System.currentTimeMillis();
        long l3 = this.lastIterTime;
        if (1000L >= l * (l2 - this.lastIterTime)) {
            return;
        }
        int n = 1;
        while (true) {
            int n2;
            int n3;
            for (n3 = 0; n3 != this.elmList.size(); ++n3) {
                CircuitElm circuitElm = this.getElm(n3);
                circuitElm.startIteration();
            }
            ++this.steps;
            for (n2 = 0; n2 != 5000; ++n2) {
                int n4;
                this.converged = true;
                this.subIterations = n2;
                for (n3 = 0; n3 != this.circuitMatrixSize; ++n3) {
                    this.circuitRightSide[n3] = this.origRightSide[n3];
                }
                if (this.circuitNonLinear) {
                    for (n3 = 0; n3 != this.circuitMatrixSize; ++n3) {
                        for (n4 = 0; n4 != this.circuitMatrixSize; ++n4) {
                            this.circuitMatrix[n3][n4] = this.origMatrix[n3][n4];
                        }
                    }
                }
                for (n3 = 0; n3 != this.elmList.size(); ++n3) {
                    CircuitElm circuitElm = this.getElm(n3);
                    circuitElm.doStep();
                }
                if (this.stopMessage != null) {
                    return;
                }
                boolean bl2 = bl;
                bl = false;
                for (n4 = 0; n4 != this.circuitMatrixSize; ++n4) {
                    for (n3 = 0; n3 != this.circuitMatrixSize; ++n3) {
                        double d = this.circuitMatrix[n3][n4];
                        if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
                        this.stop("nan/infinite matrix!", null);
                        return;
                    }
                }
                if (bl2) {
                    for (n4 = 0; n4 != this.circuitMatrixSize; ++n4) {
                        for (n3 = 0; n3 != this.circuitMatrixSize; ++n3) {
                            System.out.print(this.circuitMatrix[n4][n3] + ",");
                        }
                        System.out.print("  " + this.circuitRightSide[n4] + "\n");
                    }
                    System.out.print("\n");
                }
                if (this.circuitNonLinear) {
                    if (this.converged && n2 > 0) break;
                    if (!this.lu_factor(this.circuitMatrix, this.circuitMatrixSize, this.circuitPermute)) {
                        this.stop("Singular matrix!", null);
                        return;
                    }
                }
                this.lu_solve(this.circuitMatrix, this.circuitMatrixSize, this.circuitPermute, this.circuitRightSide);
                for (n4 = 0; n4 != this.circuitMatrixFullSize; ++n4) {
                    RowInfo rowInfo = this.circuitRowInfo[n4];
                    double d = 0.0;
                    d = rowInfo.type == 1 ? rowInfo.value : this.circuitRightSide[rowInfo.mapCol];
                    if (Double.isNaN(d)) {
                        this.converged = false;
                        break;
                    }
                    if (n4 < this.nodeList.size() - 1) {
                        CircuitNode circuitNode = this.getCircuitNode(n4 + 1);
                        for (int i = 0; i != circuitNode.links.size(); ++i) {
                            CircuitNodeLink circuitNodeLink = (CircuitNodeLink)circuitNode.links.elementAt(i);
                            circuitNodeLink.elm.setNodeVoltage(circuitNodeLink.num, d);
                        }
                        continue;
                    }
                    int n5 = n4 - (this.nodeList.size() - 1);
                    this.voltageSources[n5].setCurrent(n5, d);
                }
                if (!this.circuitNonLinear) break;
            }
            if (n2 > 5) {
                System.out.print("converged after " + n2 + " iterations\n");
            }
            if (n2 == 5000) {
                this.stop("Convergence failed!", null);
                break;
            }
            this.t += this.timeStep;
            for (n3 = 0; n3 != this.scopeCount; ++n3) {
                this.scopes[n3].timeStep();
            }
            l3 = l2 = System.currentTimeMillis();
            if ((long)(n * 1000) >= l * (l2 - this.lastIterTime) || l2 - this.lastFrameTime > 500L) break;
            ++n;
        }
        this.lastIterTime = l3;
    }

    int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    void editFuncPoint(int n, int n2) {
        this.cv.repaint(this.pause);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.cv.repaint();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.handleResize();
        this.cv.repaint(100L);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() == this.resetButton) {
            this.dbimage = main.createImage(this.winSize.width, this.winSize.height);
            for (n = 0; n != this.elmList.size(); ++n) {
                this.getElm(n).reset();
            }
            for (n = 0; n != this.scopeCount; ++n) {
                this.scopes[n].resetGraph();
            }
            this.analyzeFlag = true;
            this.t = 0.0;
            this.stoppedCheck.setState(false);
            this.cv.repaint();
        }
        if (actionEvent.getSource() == this.dumpMatrixButton) {
            this.dumpMatrix = true;
        }
        if (actionEvent.getSource() == this.exportItem) {
            this.doImport(false);
        }
        if (actionEvent.getSource() == this.optionsItem) {
            this.doEdit(new EditOptions(this));
        }
        if (actionEvent.getSource() == this.importItem) {
            this.doImport(true);
        }
        if (actionEvent.getSource() == this.undoItem) {
            this.doUndo();
        }
        if (actionEvent.getSource() == this.redoItem) {
            this.doRedo();
        }
        if (string.compareTo("Cut") == 0) {
            if (actionEvent.getSource() != this.elmCutMenuItem) {
                this.menuElm = null;
            }
            this.doCut();
        }
        if (string.compareTo("Copy") == 0) {
            if (actionEvent.getSource() != this.elmCopyMenuItem) {
                this.menuElm = null;
            }
            this.doCopy();
        }
        if (string.compareTo("Paste") == 0) {
            this.doPaste();
        }
        if (actionEvent.getSource() == this.selectAllItem) {
            this.doSelectAll();
        }
        if (actionEvent.getSource() == this.exitItem) {
            this.destroyFrame();
            return;
        }
        if (string.compareTo("stackAll") == 0) {
            this.stackAll();
        }
        if (string.compareTo("unstackAll") == 0) {
            this.unstackAll();
        }
        if (actionEvent.getSource() == this.elmEditMenuItem) {
            this.doEdit(this.menuElm);
        }
        if (string.compareTo("Delete") == 0) {
            if (actionEvent.getSource() != this.elmDeleteMenuItem) {
                this.menuElm = null;
            }
            this.doDelete();
        }
        if (actionEvent.getSource() == this.elmScopeMenuItem && this.menuElm != null) {
            for (n = 0; n != this.scopeCount && this.scopes[n].elm != null; ++n) {
            }
            if (n == this.scopeCount) {
                if (this.scopeCount == this.scopes.length) {
                    return;
                }
                ++this.scopeCount;
                this.scopes[n] = new Scope(this);
                this.scopes[n].position = n;
                this.handleResize();
            }
            this.scopes[n].setElm(this.menuElm);
        }
        if (this.menuScope != -1) {
            if (string.compareTo("remove") == 0) {
                this.scopes[this.menuScope].setElm(null);
            }
            if (string.compareTo("speed2") == 0) {
                this.scopes[this.menuScope].speedUp();
            }
            if (string.compareTo("speed1/2") == 0) {
                this.scopes[this.menuScope].slowDown();
            }
            if (string.compareTo("scale") == 0) {
                this.scopes[this.menuScope].adjustScale(0.5);
            }
            if (string.compareTo("maxscale") == 0) {
                this.scopes[this.menuScope].adjustScale(1.0E-50);
            }
            if (string.compareTo("stack") == 0) {
                this.stackScope(this.menuScope);
            }
            if (string.compareTo("unstack") == 0) {
                this.unstackScope(this.menuScope);
            }
            if (string.compareTo("selecty") == 0) {
                this.scopes[this.menuScope].selectY();
            }
            if (string.compareTo("reset") == 0) {
                this.scopes[this.menuScope].resetGraph();
            }
            this.cv.repaint();
        }
        if (string.indexOf("setup ") == 0) {
            this.pushUndo();
            this.readSetupFile(string.substring(6), ((MenuItem)actionEvent.getSource()).getLabel());
        }
    }

    void stackScope(int n) {
        if (n == 0) {
            if (this.scopeCount < 2) {
                return;
            }
            n = 1;
        }
        if (this.scopes[n].position == this.scopes[n - 1].position) {
            return;
        }
        this.scopes[n].position = this.scopes[n - 1].position;
        ++n;
        while (n < this.scopeCount) {
            --this.scopes[n].position;
            ++n;
        }
    }

    void unstackScope(int n) {
        if (n == 0) {
            if (this.scopeCount < 2) {
                return;
            }
            n = 1;
        }
        if (this.scopes[n].position != this.scopes[n - 1].position) {
            return;
        }
        while (n < this.scopeCount) {
            ++this.scopes[n].position;
            ++n;
        }
    }

    void stackAll() {
        for (int i = 0; i != this.scopeCount; ++i) {
            this.scopes[i].position = 0;
            this.scopes[i].showMin = false;
            this.scopes[i].showMax = false;
        }
    }

    void unstackAll() {
        for (int i = 0; i != this.scopeCount; ++i) {
            this.scopes[i].position = i;
            this.scopes[i].showMax = true;
        }
    }

    void doEdit(Editable editable) {
        this.clearSelection();
        this.pushUndo();
        if (editDialog != null) {
            this.requestFocus();
            editDialog.setVisible(false);
            editDialog = null;
        }
        editDialog = new EditDialog(editable, this);
        editDialog.show();
    }

    void doImport(boolean bl) {
        if (impDialog != null) {
            this.requestFocus();
            impDialog.setVisible(false);
            impDialog = null;
        }
        String string = bl ? "" : this.dumpCircuit();
        impDialog = new ImportDialog(this, string);
        impDialog.show();
        this.pushUndo();
    }

    String dumpCircuit() {
        int n;
        int n2 = this.dotsCheckItem.getState() ? 1 : 0;
        n2 |= this.smallGridCheckItem.getState() ? 2 : 0;
        n2 |= this.voltsCheckItem.getState() ? 0 : 4;
        n2 |= this.powerCheckItem.getState() ? 8 : 0;
        String string = "$ " + (n2 |= this.showValuesCheckItem.getState() ? 0 : 16) + " " + this.timeStep + " " + this.getIterCount() + " " + this.currentBar.getValue() + " " + CircuitElm.voltageRange + " " + this.powerBar.getValue() + "\n";
        for (n = 0; n != this.elmList.size(); ++n) {
            string = string + this.getElm(n).dump() + "\n";
        }
        for (n = 0; n != this.scopeCount; ++n) {
            String string2 = this.scopes[n].dump();
            if (string2 == null) continue;
            string = string + string2 + "\n";
        }
        if (this.hintType != -1) {
            string = string + "h " + this.hintType + " " + this.hintItem1 + " " + this.hintItem2 + "\n";
        }
        return string;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        System.out.print(((Scrollbar)adjustmentEvent.getSource()).getValue() + "\n");
    }

    ByteArrayOutputStream readUrlData(URL uRL) throws IOException {
        int n;
        Object object = uRL.getContent();
        FilterInputStream filterInputStream = (FilterInputStream)object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(filterInputStream.available());
        int n2 = 1024;
        byte[] byArray = new byte[n2];
        while ((n = filterInputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream;
    }

    URL getCodeBase() {
        try {
            if (this.applet != null) {
                return this.applet.getCodeBase();
            }
            File file = new File(".");
            return new URL("file:" + file.getCanonicalPath() + "/");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    void getSetupList(Menu menu, boolean bl) {
        Menu[] menuArray = new Menu[6];
        int n = 0;
        menuArray[n++] = menu;
        try {
            int n2;
            URL uRL = new URL(this.getCodeBase() + "setuplist.txt");
            ByteArrayOutputStream byteArrayOutputStream = this.readUrlData(uRL);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n3 = byteArrayOutputStream.size();
            if (n3 == 0 || byArray[0] != 35) {
                this.getSetupList(menu, true);
                return;
            }
            for (int i = 0; i < n3; i += n2) {
                String string;
                for (n2 = 0; n2 != n3 - i; ++n2) {
                    if (byArray[n2 + i] != 10) continue;
                    ++n2;
                    break;
                }
                if ((string = new String(byArray, i, n2 - 1)).charAt(0) == '#') continue;
                if (string.charAt(0) == '+') {
                    Menu menu2 = new Menu(string.substring(1));
                    menu.add(menu2);
                    int n4 = n++;
                    Menu menu3 = menu2;
                    menuArray[n4] = menu3;
                    menu = menu3;
                    continue;
                }
                if (string.charAt(0) == '-') {
                    menu = menuArray[--n - 1];
                    continue;
                }
                int n5 = string.indexOf(32);
                if (n5 <= 0) continue;
                String string2 = string.substring(n5 + 1);
                boolean bl2 = false;
                if (string.charAt(0) == '>') {
                    bl2 = true;
                }
                String string3 = string.substring(bl2 ? 1 : 0, n5);
                menu.add(this.getMenuItem(string2, "setup " + string3));
                if (!bl2 || this.startCircuit != null) continue;
                this.startCircuit = string3;
                this.startLabel = string2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.stop("Can't read setuplist.txt!", null);
        }
    }

    void readSetup(String string) {
        this.readSetup(string, false);
    }

    void readSetup(String string, boolean bl) {
        this.readSetup(string.getBytes(), string.length(), bl);
        this.titleLabel.setText("untitled");
    }

    void readSetupFile(String string, String string2) {
        this.t = 0.0;
        System.out.println(string);
        try {
            URL uRL = new URL(this.getCodeBase() + "circuits/" + string);
            ByteArrayOutputStream byteArrayOutputStream = this.readUrlData(uRL);
            this.readSetup(byteArrayOutputStream.toByteArray(), byteArrayOutputStream.size(), false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.stop("Unable to read " + string + "!", null);
        }
        this.titleLabel.setText(string2);
    }

    void readSetup(byte[] byArray, int n, boolean bl) {
        int n2;
        if (!bl) {
            for (int i = 0; i != this.elmList.size(); ++i) {
                CircuitElm circuitElm = this.getElm(i);
                circuitElm.delete();
            }
            this.elmList.removeAllElements();
            this.hintType = -1;
            this.timeStep = 5.0E-6;
            this.dotsCheckItem.setState(true);
            this.smallGridCheckItem.setState(false);
            this.powerCheckItem.setState(false);
            this.voltsCheckItem.setState(true);
            this.showValuesCheckItem.setState(true);
            this.setGrid();
            this.speedBar.setValue(117);
            this.currentBar.setValue(50);
            this.powerBar.setValue(50);
            CircuitElm.voltageRange = 5.0;
            this.scopeCount = 0;
        }
        this.cv.repaint();
        for (int i = 0; i < n; i += n2) {
            String string;
            StringTokenizer stringTokenizer;
            int n3 = 0;
            for (n2 = 0; n2 != n - i; ++n2) {
                if (byArray[n2 + i] != 10 && byArray[n2 + i] != 13) continue;
                n3 = n2++;
                if (n2 + i >= byArray.length || byArray[n2 + i] != 10) break;
                ++n2;
                break;
            }
            if (!(stringTokenizer = new StringTokenizer(string = new String(byArray, i, n3))).hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken();
            int n4 = string2.charAt(0);
            try {
                if (n4 == 111) {
                    Scope scope = new Scope(this);
                    scope.position = this.scopeCount;
                    scope.undump(stringTokenizer);
                    this.scopes[this.scopeCount++] = scope;
                    continue;
                }
                if (n4 == 104) {
                    this.readHint(stringTokenizer);
                    continue;
                }
                if (n4 == 36) {
                    this.readOptions(stringTokenizer);
                    continue;
                }
                if (n4 == 37 || n4 == 63 || n4 == 66) continue;
                if (n4 >= 48 && n4 <= 57) {
                    n4 = new Integer(string2);
                }
                int n5 = new Integer(stringTokenizer.nextToken());
                int n6 = new Integer(stringTokenizer.nextToken());
                int n7 = new Integer(stringTokenizer.nextToken());
                int n8 = new Integer(stringTokenizer.nextToken());
                int n9 = new Integer(stringTokenizer.nextToken());
                CircuitElm circuitElm = null;
                Class clazz = this.dumpTypes[n4];
                if (clazz == null) {
                    System.out.println("unrecognized dump type: " + string2);
                    continue;
                }
                Class[] classArray = new Class[6];
                classArray[3] = classArray[4] = Integer.TYPE;
                classArray[2] = classArray[4];
                classArray[1] = classArray[4];
                classArray[0] = classArray[4];
                classArray[5] = StringTokenizer.class;
                Constructor constructor = null;
                constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{new Integer(n5), new Integer(n6), new Integer(n7), new Integer(n8), new Integer(n9), stringTokenizer};
                circuitElm = (CircuitElm)constructor.newInstance(objectArray);
                circuitElm.setPoints();
                this.elmList.addElement(circuitElm);
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.enableItems();
        if (!bl) {
            this.handleResize();
        }
        this.needAnalyze();
    }

    void readHint(StringTokenizer stringTokenizer) {
        this.hintType = new Integer(stringTokenizer.nextToken());
        this.hintItem1 = new Integer(stringTokenizer.nextToken());
        this.hintItem2 = new Integer(stringTokenizer.nextToken());
    }

    void readOptions(StringTokenizer stringTokenizer) {
        int n = new Integer(stringTokenizer.nextToken());
        this.dotsCheckItem.setState((n & 1) != 0);
        this.smallGridCheckItem.setState((n & 2) != 0);
        this.voltsCheckItem.setState((n & 4) == 0);
        this.powerCheckItem.setState((n & 8) == 8);
        this.showValuesCheckItem.setState((n & 0x10) == 0);
        this.timeStep = new Double(stringTokenizer.nextToken());
        double d = new Double(stringTokenizer.nextToken());
        int n2 = (int)(Math.log(10.0 * d) * 24.0 + 61.5);
        this.speedBar.setValue(n2);
        this.currentBar.setValue(new Integer(stringTokenizer.nextToken()));
        CircuitElm.voltageRange = new Double(stringTokenizer.nextToken());
        try {
            this.powerBar.setValue(new Integer(stringTokenizer.nextToken()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setGrid();
    }

    int snapGrid(int n) {
        return n + this.gridRound & this.gridMask;
    }

    boolean doSwitch(int n, int n2) {
        if (this.mouseElm == null || !(this.mouseElm instanceof SwitchElm)) {
            return false;
        }
        SwitchElm switchElm = (SwitchElm)this.mouseElm;
        switchElm.toggle();
        if (switchElm.momentary) {
            this.heldSwitchElm = switchElm;
        }
        this.needAnalyze();
        return true;
    }

    int locateElm(CircuitElm circuitElm) {
        for (int i = 0; i != this.elmList.size(); ++i) {
            if (circuitElm != this.elmList.elementAt(i)) continue;
            return i;
        }
        return -1;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        if ((mouseEvent.getModifiers() & 4) != 0 && ((n = mouseEvent.getModifiersEx()) & 0x3C0) == 0) {
            return;
        }
        if (!this.circuitArea.contains(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        if (this.dragElm != null) {
            this.dragElm.drag(mouseEvent.getX(), mouseEvent.getY());
        }
        n = 1;
        switch (this.tempMouseMode) {
            case 1: {
                this.dragAll(this.snapGrid(mouseEvent.getX()), this.snapGrid(mouseEvent.getY()));
                break;
            }
            case 2: {
                this.dragRow(this.snapGrid(mouseEvent.getX()), this.snapGrid(mouseEvent.getY()));
                break;
            }
            case 3: {
                this.dragColumn(this.snapGrid(mouseEvent.getX()), this.snapGrid(mouseEvent.getY()));
                break;
            }
            case 5: {
                if (this.mouseElm == null) break;
                this.dragPost(this.snapGrid(mouseEvent.getX()), this.snapGrid(mouseEvent.getY()));
                break;
            }
            case 6: {
                if (this.mouseElm == null) {
                    this.selectArea(mouseEvent.getX(), mouseEvent.getY());
                    break;
                }
                this.tempMouseMode = 4;
                n = this.dragSelected(mouseEvent.getX(), mouseEvent.getY()) ? 1 : 0;
                break;
            }
            case 4: {
                n = this.dragSelected(mouseEvent.getX(), mouseEvent.getY()) ? 1 : 0;
            }
        }
        this.dragging = true;
        if (n != 0) {
            if (this.tempMouseMode == 4 && this.mouseElm instanceof TextElm) {
                this.dragX = mouseEvent.getX();
                this.dragY = mouseEvent.getY();
            } else {
                this.dragX = this.snapGrid(mouseEvent.getX());
                this.dragY = this.snapGrid(mouseEvent.getY());
            }
        }
        this.cv.repaint(this.pause);
    }

    void dragAll(int n, int n2) {
        int n3 = n - this.dragX;
        int n4 = n2 - this.dragY;
        if (n3 == 0 && n4 == 0) {
            return;
        }
        for (int i = 0; i != this.elmList.size(); ++i) {
            CircuitElm circuitElm = this.getElm(i);
            circuitElm.move(n3, n4);
        }
        this.removeZeroLengthElements();
    }

    void dragRow(int n, int n2) {
        int n3 = n2 - this.dragY;
        if (n3 == 0) {
            return;
        }
        for (int i = 0; i != this.elmList.size(); ++i) {
            CircuitElm circuitElm = this.getElm(i);
            if (circuitElm.y == this.dragY) {
                circuitElm.movePoint(0, 0, n3);
            }
            if (circuitElm.y2 != this.dragY) continue;
            circuitElm.movePoint(1, 0, n3);
        }
        this.removeZeroLengthElements();
    }

    void dragColumn(int n, int n2) {
        int n3 = n - this.dragX;
        if (n3 == 0) {
            return;
        }
        for (int i = 0; i != this.elmList.size(); ++i) {
            CircuitElm circuitElm = this.getElm(i);
            if (circuitElm.x == this.dragX) {
                circuitElm.movePoint(0, n3, 0);
            }
            if (circuitElm.x2 != this.dragX) continue;
            circuitElm.movePoint(1, n3, 0);
        }
        this.removeZeroLengthElements();
    }

    boolean dragSelected(int n, int n2) {
        CircuitElm circuitElm;
        CircuitElm circuitElm2;
        int n3;
        boolean bl = false;
        if (this.mouseElm != null && !this.mouseElm.isSelected()) {
            bl = true;
            this.mouseElm.setSelected(true);
        }
        for (n3 = 0; n3 != this.elmList.size() && (!(circuitElm2 = this.getElm(n3)).isSelected() || circuitElm2 instanceof TextElm); ++n3) {
        }
        if (n3 != this.elmList.size()) {
            n = this.snapGrid(n);
            n2 = this.snapGrid(n2);
        }
        int n4 = n - this.dragX;
        int n5 = n2 - this.dragY;
        if (n4 == 0 && n5 == 0) {
            if (bl) {
                this.mouseElm.setSelected(false);
            }
            return false;
        }
        boolean bl2 = true;
        for (n3 = 0; bl2 && n3 != this.elmList.size(); ++n3) {
            circuitElm = this.getElm(n3);
            if (!circuitElm.isSelected() || circuitElm.allowMove(n4, n5)) continue;
            bl2 = false;
        }
        if (bl2) {
            for (n3 = 0; n3 != this.elmList.size(); ++n3) {
                circuitElm = this.getElm(n3);
                if (!circuitElm.isSelected()) continue;
                circuitElm.move(n4, n5);
            }
            this.needAnalyze();
        }
        if (bl) {
            this.mouseElm.setSelected(false);
        }
        return bl2;
    }

    void dragPost(int n, int n2) {
        if (this.draggingPost == -1) {
            this.draggingPost = this.distanceSq(this.mouseElm.x, this.mouseElm.y, n, n2) > this.distanceSq(this.mouseElm.x2, this.mouseElm.y2, n, n2) ? 1 : 0;
        }
        int n3 = n - this.dragX;
        int n4 = n2 - this.dragY;
        if (n3 == 0 && n4 == 0) {
            return;
        }
        this.mouseElm.movePoint(this.draggingPost, n3, n4);
        this.needAnalyze();
    }

    void selectArea(int n, int n2) {
        int n3 = this.min(n, this.initDragX);
        int n4 = this.max(n, this.initDragX);
        int n5 = this.min(n2, this.initDragY);
        int n6 = this.max(n2, this.initDragY);
        this.selectedArea = new Rectangle(n3, n5, n4 - n3, n6 - n5);
        for (int i = 0; i != this.elmList.size(); ++i) {
            CircuitElm circuitElm = this.getElm(i);
            circuitElm.selectRect(this.selectedArea);
        }
    }

    void setSelectedElm(CircuitElm circuitElm) {
        for (int i = 0; i != this.elmList.size(); ++i) {
            CircuitElm circuitElm2;
            circuitElm2.setSelected((circuitElm2 = this.getElm(i)) == circuitElm);
        }
        this.mouseElm = circuitElm;
    }

    void removeZeroLengthElements() {
        boolean bl = false;
        for (int i = this.elmList.size() - 1; i >= 0; --i) {
            CircuitElm circuitElm = this.getElm(i);
            if (circuitElm.x != circuitElm.x2 || circuitElm.y != circuitElm.y2) continue;
            this.elmList.removeElementAt(i);
            circuitElm.delete();
            bl = true;
        }
        this.needAnalyze();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2;
        Object object;
        int n3;
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            return;
        }
        int n4 = mouseEvent.getX();
        int n5 = mouseEvent.getY();
        this.dragX = this.snapGrid(n4);
        this.dragY = this.snapGrid(n5);
        this.draggingPost = -1;
        CircuitElm circuitElm = this.mouseElm;
        this.mouseElm = null;
        this.mousePost = -1;
        this.plotYElm = null;
        this.plotXElm = null;
        int n6 = 100000;
        int n7 = 100000;
        for (n3 = 0; n3 != this.elmList.size(); ++n3) {
            object = this.getElm(n3);
            if (!((CircuitElm)object).boundingBox.contains(n4, n5)) continue;
            n2 = ((CircuitElm)object).boundingBox.width * ((CircuitElm)object).boundingBox.height;
            int n8 = ((CircuitElm)object).getPostCount();
            if (n8 > 2) {
                n8 = 2;
            }
            for (n = 0; n != n8; ++n) {
                Point point = ((CircuitElm)object).getPost(n);
                int n9 = this.distanceSq(n4, n5, point.x, point.y);
                if (n9 > n6 || n2 > n7) continue;
                n6 = n9;
                n7 = n2;
                this.mouseElm = object;
            }
            if (((CircuitElm)object).getPostCount() != 0) continue;
            this.mouseElm = object;
        }
        this.scopeSelected = -1;
        if (this.mouseElm == null) {
            for (n3 = 0; n3 != this.scopeCount; ++n3) {
                object = this.scopes[n3];
                if (!((Scope)object).rect.contains(n4, n5)) continue;
                ((Scope)object).select();
                this.scopeSelected = n3;
            }
            block3: for (n3 = 0; n3 != this.elmList.size(); ++n3) {
                object = this.getElm(n3);
                n2 = ((CircuitElm)object).getPostCount();
                for (n = 0; n != n2; ++n) {
                    Point point = ((CircuitElm)object).getPost(n);
                    int n10 = this.distanceSq(n4, n5, point.x, point.y);
                    if (this.distanceSq(point.x, point.y, n4, n5) >= 26) continue;
                    this.mouseElm = object;
                    this.mousePost = n;
                    continue block3;
                }
            }
        } else {
            this.mousePost = -1;
            for (n3 = 0; n3 != this.mouseElm.getPostCount(); ++n3) {
                object = this.mouseElm.getPost(n3);
                if (this.distanceSq(((Point)object).x, ((Point)object).y, n4, n5) >= 26) continue;
                this.mousePost = n3;
            }
        }
        if (this.mouseElm != circuitElm) {
            this.cv.repaint();
        }
    }

    int distanceSq(int n, int n2, int n3, int n4) {
        return (n3 -= n) * n3 + (n4 -= n2) * n4;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && (this.mouseMode == 6 || this.mouseMode == 4)) {
            this.clearSelection();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.scopeSelected = -1;
        this.plotYElm = null;
        this.plotXElm = null;
        this.mouseElm = null;
        this.cv.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        System.out.println(mouseEvent.getModifiers());
        int n2 = mouseEvent.getModifiersEx();
        if ((n2 & 0x140) == 0 && mouseEvent.isPopupTrigger()) {
            this.doPopupMenu(mouseEvent);
            return;
        }
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            this.tempMouseMode = this.mouseMode;
            if ((n2 & 0x200) != 0 && (n2 & 0x100) != 0) {
                this.tempMouseMode = 3;
            } else if ((n2 & 0x200) != 0 && (n2 & 0x40) != 0) {
                this.tempMouseMode = 2;
            } else if ((n2 & 0x40) != 0) {
                this.tempMouseMode = 6;
            } else if ((n2 & 0x200) != 0) {
                this.tempMouseMode = 1;
            } else if ((n2 & 0x180) != 0) {
                this.tempMouseMode = 5;
            }
        } else if ((mouseEvent.getModifiers() & 4) != 0) {
            if ((n2 & 0x40) != 0) {
                this.tempMouseMode = 2;
            } else if ((n2 & 0x180) != 0) {
                this.tempMouseMode = 3;
            } else {
                return;
            }
        }
        if (this.tempMouseMode != 6 && this.tempMouseMode != 4) {
            this.clearSelection();
        }
        if (this.doSwitch(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        this.pushUndo();
        this.initDragX = mouseEvent.getX();
        this.initDragY = mouseEvent.getY();
        this.dragging = true;
        if (this.tempMouseMode != 0 || this.addingClass == null) {
            return;
        }
        int n3 = this.snapGrid(mouseEvent.getX());
        if (!this.circuitArea.contains(n3, n = this.snapGrid(mouseEvent.getY()))) {
            return;
        }
        this.dragElm = this.constructElement(this.addingClass, n3, n);
    }

    CircuitElm constructElement(Class clazz, int n, int n2) {
        Class[] classArray = new Class[2];
        classArray[0] = classArray[1] = Integer.TYPE;
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("caught NoSuchMethodException " + clazz);
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        try {
            return (CircuitElm)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    void doPopupMenu(MouseEvent mouseEvent) {
        this.menuElm = this.mouseElm;
        this.menuScope = -1;
        if (this.scopeSelected != -1) {
            PopupMenu popupMenu = this.scopes[this.scopeSelected].getMenu();
            this.menuScope = this.scopeSelected;
            if (popupMenu != null) {
                popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (this.mouseElm != null) {
            this.elmEditMenuItem.setEnabled(this.mouseElm.getEditInfo(0) != null);
            this.elmScopeMenuItem.setEnabled(this.mouseElm.canViewInScope());
            this.elmMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.doMainMenuChecks(this.mainMenu);
            this.mainMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void doMainMenuChecks(Menu menu) {
        if (menu == this.optionsMenu) {
            return;
        }
        for (int i = 0; i != menu.getItemCount(); ++i) {
            CheckboxMenuItem checkboxMenuItem;
            MenuItem menuItem = menu.getItem(i);
            if (menuItem instanceof Menu) {
                this.doMainMenuChecks((Menu)menuItem);
            }
            if (!(menuItem instanceof CheckboxMenuItem)) continue;
            checkboxMenuItem.setState(this.mouseModeStr.compareTo((checkboxMenuItem = (CheckboxMenuItem)menuItem).getActionCommand()) == 0);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        if ((n & 0x1C0) == 0 && mouseEvent.isPopupTrigger()) {
            this.doPopupMenu(mouseEvent);
            return;
        }
        this.tempMouseMode = this.mouseMode;
        this.selectedArea = null;
        this.dragging = false;
        boolean bl = false;
        if (this.heldSwitchElm != null) {
            this.heldSwitchElm.mouseUp();
            this.heldSwitchElm = null;
            bl = true;
        }
        if (this.dragElm != null) {
            if (this.dragElm.x == this.dragElm.x2 && this.dragElm.y == this.dragElm.y2) {
                this.dragElm.delete();
            } else {
                this.elmList.addElement(this.dragElm);
                bl = true;
            }
            this.dragElm = null;
        }
        if (bl) {
            this.needAnalyze();
        }
        if (this.dragElm != null) {
            this.dragElm.delete();
        }
        this.dragElm = null;
        this.cv.repaint();
    }

    void enableItems() {
        if (this.powerCheckItem.getState()) {
            this.powerBar.enable();
            this.powerLabel.enable();
        } else {
            this.powerBar.disable();
            this.powerLabel.disable();
        }
        this.enableUndoRedo();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        this.cv.repaint(this.pause);
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.stoppedCheck) {
            return;
        }
        if (itemSelectable == this.smallGridCheckItem) {
            this.setGrid();
        }
        if (itemSelectable == this.powerCheckItem) {
            if (this.powerCheckItem.getState()) {
                this.voltsCheckItem.setState(false);
            } else {
                this.voltsCheckItem.setState(true);
            }
        }
        if (itemSelectable == this.voltsCheckItem && this.voltsCheckItem.getState()) {
            this.powerCheckItem.setState(false);
        }
        this.enableItems();
        if (this.menuScope != -1) {
            object = this.scopes[this.menuScope];
            ((Scope)object).handleMenu(itemEvent, itemSelectable);
        }
        if (itemSelectable instanceof CheckboxMenuItem) {
            object = (MenuItem)((Object)itemSelectable);
            this.mouseMode = 0;
            String string = ((MenuItem)object).getActionCommand();
            if (string.length() > 0) {
                this.mouseModeStr = string;
            }
            if (string.compareTo("DragAll") == 0) {
                this.mouseMode = 1;
            } else if (string.compareTo("DragRow") == 0) {
                this.mouseMode = 2;
            } else if (string.compareTo("DragColumn") == 0) {
                this.mouseMode = 3;
            } else if (string.compareTo("DragSelected") == 0) {
                this.mouseMode = 4;
            } else if (string.compareTo("DragPost") == 0) {
                this.mouseMode = 5;
            } else if (string.compareTo("Select") == 0) {
                this.mouseMode = 6;
            } else if (string.length() > 0) {
                try {
                    this.addingClass = Class.forName(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.tempMouseMode = this.mouseMode;
        }
    }

    void setGrid() {
        this.gridSize = this.smallGridCheckItem.getState() ? 8 : 16;
        this.gridMask = ~(this.gridSize - 1);
        this.gridRound = this.gridSize / 2 - 1;
    }

    void pushUndo() {
        this.redoStack.removeAllElements();
        String string = this.dumpCircuit();
        if (this.undoStack.size() > 0 && string.compareTo((String)this.undoStack.lastElement()) == 0) {
            return;
        }
        this.undoStack.add(string);
        this.enableUndoRedo();
    }

    void doUndo() {
        if (this.undoStack.size() == 0) {
            return;
        }
        this.redoStack.add(this.dumpCircuit());
        String string = (String)this.undoStack.remove(this.undoStack.size() - 1);
        this.readSetup(string);
        this.enableUndoRedo();
    }

    void doRedo() {
        if (this.redoStack.size() == 0) {
            return;
        }
        this.undoStack.add(this.dumpCircuit());
        String string = (String)this.redoStack.remove(this.redoStack.size() - 1);
        this.readSetup(string);
        this.enableUndoRedo();
    }

    void enableUndoRedo() {
        this.redoItem.setEnabled(this.redoStack.size() > 0);
        this.undoItem.setEnabled(this.undoStack.size() > 0);
    }

    void setMenuSelection() {
        if (this.menuElm != null) {
            if (this.menuElm.selected) {
                return;
            }
            this.clearSelection();
            this.menuElm.setSelected(true);
        }
    }

    void doCut() {
        this.pushUndo();
        this.setMenuSelection();
        this.clipboard = "";
        for (int i = this.elmList.size() - 1; i >= 0; --i) {
            CircuitElm circuitElm = this.getElm(i);
            if (!circuitElm.isSelected()) continue;
            this.clipboard = this.clipboard + circuitElm.dump() + "\n";
            circuitElm.delete();
            this.elmList.removeElementAt(i);
        }
        this.enablePaste();
        this.needAnalyze();
    }

    void doDelete() {
        this.pushUndo();
        this.setMenuSelection();
        for (int i = this.elmList.size() - 1; i >= 0; --i) {
            CircuitElm circuitElm = this.getElm(i);
            if (!circuitElm.isSelected()) continue;
            circuitElm.delete();
            this.elmList.removeElementAt(i);
        }
        this.needAnalyze();
    }

    void doCopy() {
        this.clipboard = "";
        this.setMenuSelection();
        for (int i = this.elmList.size() - 1; i >= 0; --i) {
            CircuitElm circuitElm = this.getElm(i);
            if (!circuitElm.isSelected()) continue;
            this.clipboard = this.clipboard + circuitElm.dump() + "\n";
        }
        this.enablePaste();
    }

    void enablePaste() {
        this.pasteItem.setEnabled(this.clipboard.length() > 0);
    }

    void doPaste() {
        Rectangle rectangle;
        int n;
        this.pushUndo();
        this.clearSelection();
        Rectangle rectangle2 = null;
        for (n = 0; n != this.elmList.size(); ++n) {
            CircuitElm circuitElm = this.getElm(n);
            rectangle = circuitElm.getBoundingBox();
            rectangle2 = rectangle2 != null ? rectangle2.union(rectangle) : rectangle;
        }
        int n2 = this.elmList.size();
        this.readSetup(this.clipboard, true);
        rectangle = null;
        for (n = n2; n != this.elmList.size(); ++n) {
            CircuitElm circuitElm = this.getElm(n);
            circuitElm.setSelected(true);
            Rectangle rectangle3 = circuitElm.getBoundingBox();
            rectangle = rectangle != null ? rectangle.union(rectangle3) : rectangle3;
        }
        if (rectangle2 != null && rectangle != null && rectangle2.intersects(rectangle)) {
            int n3 = 0;
            int n4 = 0;
            int n5 = this.circuitArea.width - rectangle2.width - rectangle.width;
            int n6 = this.circuitArea.height - rectangle2.height - rectangle.height;
            if (n5 > n6) {
                n3 = this.snapGrid(rectangle2.x + rectangle2.width - rectangle.x + this.gridSize);
            } else {
                n4 = this.snapGrid(rectangle2.y + rectangle2.height - rectangle.y + this.gridSize);
            }
            for (n = n2; n != this.elmList.size(); ++n) {
                CircuitElm circuitElm = this.getElm(n);
                circuitElm.move(n3, n4);
            }
            this.handleResize();
        }
        this.needAnalyze();
    }

    void clearSelection() {
        for (int i = 0; i != this.elmList.size(); ++i) {
            CircuitElm circuitElm = this.getElm(i);
            circuitElm.setSelected(false);
        }
    }

    void doSelectAll() {
        for (int i = 0; i != this.elmList.size(); ++i) {
            CircuitElm circuitElm = this.getElm(i);
            circuitElm.setSelected(true);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() > ' ' && keyEvent.getKeyChar() < '\u007f') {
            Class clazz = this.dumpTypes[keyEvent.getKeyChar()];
            if (clazz == null || clazz == Scope.class) {
                return;
            }
            CircuitElm circuitElm = null;
            circuitElm = this.constructElement(clazz, 0, 0);
            if (circuitElm == null || !circuitElm.needsShortcut() || circuitElm.getDumpClass() != clazz) {
                return;
            }
            this.mouseMode = 0;
            this.mouseModeStr = clazz.getName();
            this.addingClass = clazz;
        }
        if (keyEvent.getKeyChar() == ' ') {
            this.mouseMode = 6;
            this.mouseModeStr = "Select";
        }
        this.tempMouseMode = this.mouseMode;
    }

    boolean lu_factor(double[][] dArray, int n, int[] nArray) {
        int n2;
        double d;
        int n3;
        double[] dArray2 = new double[n];
        for (n3 = 0; n3 != n; ++n3) {
            d = 0.0;
            for (n2 = 0; n2 != n; ++n2) {
                double d2 = Math.abs(dArray[n3][n2]);
                if (!(d2 > d)) continue;
                d = d2;
            }
            if (d == 0.0) {
                return false;
            }
            dArray2[n3] = 1.0 / d;
        }
        for (n2 = 0; n2 != n; ++n2) {
            double d3;
            int n4;
            for (n3 = 0; n3 != n2; ++n3) {
                d = dArray[n3][n2];
                for (n4 = 0; n4 != n3; ++n4) {
                    d -= dArray[n3][n4] * dArray[n4][n2];
                }
                dArray[n3][n2] = d;
            }
            d = 0.0;
            int n5 = -1;
            for (n3 = n2; n3 != n; ++n3) {
                d3 = dArray[n3][n2];
                for (n4 = 0; n4 != n2; ++n4) {
                    d3 -= dArray[n3][n4] * dArray[n4][n2];
                }
                dArray[n3][n2] = d3;
                double d4 = Math.abs(d3);
                if (!(d4 >= d)) continue;
                d = d4;
                n5 = n3;
            }
            if (n2 != n5) {
                for (n4 = 0; n4 != n; ++n4) {
                    d3 = dArray[n5][n4];
                    dArray[n5][n4] = dArray[n2][n4];
                    dArray[n2][n4] = d3;
                }
                dArray2[n5] = dArray2[n2];
            }
            nArray[n2] = n5;
            if (dArray[n2][n2] == 0.0) {
                System.out.println("avoided zero");
                dArray[n2][n2] = 1.0E-18;
            }
            if (n2 == n - 1) continue;
            d3 = 1.0 / dArray[n2][n2];
            for (n3 = n2 + 1; n3 != n; ++n3) {
                double[] dArray3 = dArray[n3];
                int n6 = n2;
                dArray3[n6] = dArray3[n6] * d3;
            }
        }
        return true;
    }

    void lu_solve(double[][] dArray, int n, int[] nArray, double[] dArray2) {
        double d;
        int n2;
        int n3;
        for (n3 = 0; n3 != n; ++n3) {
            n2 = nArray[n3];
            d = dArray2[n2];
            dArray2[n2] = dArray2[n3];
            dArray2[n3] = d;
            if (d != 0.0) break;
        }
        n2 = n3++;
        while (n3 < n) {
            int n4 = nArray[n3];
            double d2 = dArray2[n4];
            dArray2[n4] = dArray2[n3];
            for (int i = n2; i < n3; ++i) {
                d2 -= dArray[n3][i] * dArray2[i];
            }
            dArray2[n3] = d2;
            ++n3;
        }
        for (n3 = n - 1; n3 >= 0; --n3) {
            d = dArray2[n3];
            for (int i = n3 + 1; i != n; ++i) {
                d -= dArray[n3][i] * dArray2[i];
            }
            dArray2[n3] = d / dArray[n3][n3];
        }
    }

    static {
        muString = "u";
        ohmString = "ohm";
    }

    class FindPathInfo {
        static final int INDUCT = 1;
        static final int VOLTAGE = 2;
        static final int SHORT = 3;
        static final int CAP_V = 4;
        boolean[] used;
        int dest;
        CircuitElm firstElm;
        int type;

        FindPathInfo(int n, CircuitElm circuitElm, int n2) {
            this.dest = n2;
            this.type = n;
            this.firstElm = circuitElm;
            this.used = new boolean[CirSim.this.nodeList.size()];
        }

        boolean findPath(int n) {
            return this.findPath(n, -1);
        }

        boolean findPath(int n, int n2) {
            if (n == this.dest) {
                return true;
            }
            if (n2-- == 0) {
                return false;
            }
            if (this.used[n]) {
                return false;
            }
            this.used[n] = true;
            for (int i = 0; i != CirSim.this.elmList.size(); ++i) {
                int n3;
                CircuitElm circuitElm = CirSim.this.getElm(i);
                if (circuitElm == this.firstElm || this.type == 1 && circuitElm instanceof CurrentElm || this.type == 2 && !circuitElm.isWire() && !(circuitElm instanceof VoltageElm) || this.type == 3 && !circuitElm.isWire() || this.type == 4 && !circuitElm.isWire() && !(circuitElm instanceof CapacitorElm) && !(circuitElm instanceof VoltageElm)) continue;
                if (n == 0) {
                    for (n3 = 0; n3 != circuitElm.getPostCount(); ++n3) {
                        if (!circuitElm.hasGroundConnection(n3) || !this.findPath(circuitElm.getNode(n3), n2)) continue;
                        this.used[n] = false;
                        return true;
                    }
                }
                for (n3 = 0; n3 != circuitElm.getPostCount() && circuitElm.getNode(n3) != n; ++n3) {
                }
                if (n3 == circuitElm.getPostCount()) continue;
                if (circuitElm.hasGroundConnection(n3) && this.findPath(0, n2)) {
                    this.used[n] = false;
                    return true;
                }
                if (this.type == 1 && circuitElm instanceof InductorElm) {
                    double d = circuitElm.getCurrent();
                    if (n3 == 0) {
                        d = -d;
                    }
                    if (Math.abs(d - this.firstElm.getCurrent()) > 1.0E-10) continue;
                }
                for (int j = 0; j != circuitElm.getPostCount(); ++j) {
                    if (n3 == j || !circuitElm.getConnection(n3, j) || !this.findPath(circuitElm.getNode(j), n2)) continue;
                    this.used[n] = false;
                    return true;
                }
            }
            this.used[n] = false;
            return false;
        }
    }
}

