/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class AnalogSwitch2Elm
extends AnalogSwitchElm {
    final int openhs = 16;
    Point[] swposts;
    Point[] swpoles;
    Point ctlPoint;

    public AnalogSwitch2Elm(int n, int n2) {
        super(n, n2);
    }

    public AnalogSwitch2Elm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
    }

    void setPoints() {
        super.setPoints();
        this.calcLeads(32);
        this.swposts = this.newPointArray(2);
        this.swpoles = this.newPointArray(2);
        this.interpPoint2(this.lead1, this.lead2, this.swpoles[0], this.swpoles[1], 1.0, 16.0);
        this.interpPoint2(this.point1, this.point2, this.swposts[0], this.swposts[1], 1.0, 16.0);
        this.ctlPoint = this.interpPoint(this.point1, this.point2, 0.5, 16.0);
    }

    int getPostCount() {
        return 4;
    }

    void draw(Graphics graphics) {
        this.setBbox(this.point1, this.point2, 16.0);
        this.setVoltageColor(graphics, this.volts[0]);
        AnalogSwitch2Elm.drawThickLine(graphics, this.point1, this.lead1);
        this.setVoltageColor(graphics, this.volts[1]);
        AnalogSwitch2Elm.drawThickLine(graphics, this.swpoles[0], this.swposts[0]);
        this.setVoltageColor(graphics, this.volts[2]);
        AnalogSwitch2Elm.drawThickLine(graphics, this.swpoles[1], this.swposts[1]);
        graphics.setColor(lightGrayColor);
        int n = this.open ? 1 : 0;
        AnalogSwitch2Elm.drawThickLine(graphics, this.lead1, this.swpoles[n]);
        this.updateDotCount();
        this.drawDots(graphics, this.point1, this.lead1, this.curcount);
        this.drawDots(graphics, this.swpoles[n], this.swposts[n], this.curcount);
        this.drawPosts(graphics);
    }

    Point getPost(int n) {
        return n == 0 ? this.point1 : (n == 3 ? this.ctlPoint : this.swposts[n - 1]);
    }

    int getDumpType() {
        return 160;
    }

    void calculateCurrent() {
        this.current = this.open ? (this.volts[0] - this.volts[2]) / this.r_on : (this.volts[0] - this.volts[1]) / this.r_on;
    }

    void stamp() {
        sim.stampNonLinear(this.nodes[0]);
        sim.stampNonLinear(this.nodes[1]);
        sim.stampNonLinear(this.nodes[2]);
    }

    void doStep() {
        boolean bl = this.open = this.volts[3] < 2.5;
        if ((this.flags & 1) != 0) {
            boolean bl2 = this.open = !this.open;
        }
        if (this.open) {
            sim.stampResistor(this.nodes[0], this.nodes[2], this.r_on);
            sim.stampResistor(this.nodes[0], this.nodes[1], this.r_off);
        } else {
            sim.stampResistor(this.nodes[0], this.nodes[1], this.r_on);
            sim.stampResistor(this.nodes[0], this.nodes[2], this.r_off);
        }
    }

    boolean getConnection(int n, int n2) {
        return n != 3 && n2 != 3;
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "analog switch (DPST)";
        stringArray[1] = "I = " + AnalogSwitch2Elm.getCurrentDText(this.getCurrent());
    }
}

